#define IF_HASH_SIZE 5000
#define IF_HASH(ifindex) (ifindex % IF_HASH_SIZE)


typedef enum if_type_ {
	IF_TYPE_BRIDGE	= 1,
	IF_TYPE_VLAN,
	IF_TYPE_OTHER
} if_type_e;

typedef struct if_info_ {
	int ifindex;
	int type;
	char ifname[16];
	u32 flags;
	int vlan_aware;
	int vlan_id;
	void *data;
	struct if_info_ *hnext;
} if_info_t;

typedef struct {
	int count;
	if_info_t *if_nodes[IF_HASH_SIZE];
}if_hash_table_t;

typedef struct br_if_info_ {
	if_info_t *parent;
	struct dl_list tag_mbr_interfaces;
	struct dl_list untag_mbr_interfaces;
	int master_id;
} br_if_info_t;

typedef struct vlan_if_info_ {
	if_info_t *parent;
	struct dl_list mbr_if_list;
	if_info_t *master;
	int orig_master_id;
	int master_id;
} vlan_if_info_t;

if_hash_table_t *if_hash_table_alloc();
if_info_t *if_info_alloc(int type, int ifindex, char *ifname, u32 flags);
if_info_t * if_hash_table_find(if_hash_table_t *ht, int ifindex);
void if_hash_table_add(if_hash_table_t *ht, if_info_t *if_node);
void if_hash_table_del(if_hash_table_t *ht, int ifindex);
void if_hash_table_free(if_hash_table_t *ht);
void if_hash_table_foreach(if_hash_table_t *ht,
			int (*foreach_cb)(void *data, void *cbarg), void *cbarg);
if_info_t * if_hash_table_find_by_vlan(if_hash_table_t *ht, int vlan_id);
if_info_t *if_get_br(if_info_t *if_node);
void if_update_master(if_info_t *if_node, if_info_t *master);
void if_mbr_list_add (if_info_t *br_node, if_info_t *if_node);
