#!/usr/bin/env python3

import argparse
import logging
from nlmanager.nlmanager import NetlinkManager

# Logging and args
logging.basicConfig(
    level=logging.DEBUG, format='%(asctime)s %(levelname)7s: %(message)s')
log = logging.getLogger()


def interval(arg):
    if arg.count("-") == 1:
        start, end = arg.split("-")
        return int(start), int(end)
    else:
        return (int(arg),)


parser = argparse.ArgumentParser(
    description="Modify bridge vlan filter tunnel_info entries")
parser.add_argument(
    "cmd",
    choices=("add", "del"),
    help="command",
)
parser.add_argument(
    "ifindex",
    type=int,
    help="interface index",
)
parser.add_argument(
    "vlan_id",
    type=interval,
    help="vlan id or interval (<start>-<end>)",
)
parser.add_argument(
    "tunnel_id",
    type=interval,
    help="tunnel id or interval (<start>-<end>)",
)
args = parser.parse_args()

if len(args.vlan_id) == 2:
    assert len(args.tunnel_id) == 2
    l = args.vlan_id[1] - args.vlan_id[0] + 1
    assert l == args.vlan_id[1] - args.vlan_id[0] + 1
else:
    l = 1

nlmanager = NetlinkManager()
nlmanager.debug_link(True)

funcs = {
    "add": nlmanager.link_add_bridge_vlan_tunnel_info,
    "del": nlmanager.link_del_bridge_vlan_tunnel_info,
}

funcs[args.cmd](
    args.ifindex, args.vlan_id[0], args.tunnel_id[0], l)
