#!/usr/bin/env python

import argparse
import logging
from nlmanager.nlmanager import NetlinkManager
from nlmanager.nlpacket import RTM_DELLINK

# Logging and args
logging.basicConfig(level=logging.DEBUG,
                    format='%(asctime)s %(levelname)7s: %(message)s')
log = logging.getLogger()

parser = argparse.ArgumentParser(description="Remove a interval of bridge vlan filter entries")
parser.add_argument('ifindex', type=int, help='bridge port interface index')
parser.add_argument('vlanstart', type=int, help='vlan ID')
parser.add_argument('vlanend', type=int, help='vlan ID')
args = parser.parse_args()

nlmanager = NetlinkManager()
nlmanager.debug_link(True)

log.info("Calling vlan_modify() with ifindex %d, vlan start %d, vlan end %d" % (args.ifindex, args.vlanstart, args.vlanend))
nlmanager.vlan_modify(RTM_DELLINK, args.ifindex, args.vlanstart, args.vlanend)
