#!/usr/bin/env python

import socket
import os, os.path
import subprocess
import csv
import re
import sys
import StringIO
from itertools import groupby
import argparse

ptm_sockname = "\0/var/run/ptmd-quagga.socket"

from collections import namedtuple
from ctypes import *

class sockaddr_in(BigEndianStructure):
    _pack_ = 1
    _fields_ = [
        ('sin_family',  c_uint16),
        ('sin_port',    c_uint16),
        ('sin_addr',    c_uint32),
        ('sin_zero',    c_uint64)
    ]


class sockaddr_in6(BigEndianStructure):
    _pack_ = 1
    _fields_ = [
        ('sin6_family',     c_uint16),
        ('sin6_port',       c_uint16),
        ('sin6_flowinfo',   c_uint32),
        ('sin6_addr',       c_uint64 * 2),
        ('sin6_scope_id',   c_uint32)
    ]


class PtmClient(socket.socket):
    def __init__(self):
        try:
            self._sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
            self._sock.connect(ptm_sockname)

        except socket.error, (errno, string):

           print "Service not running, unable to connect to server"
           sys.exit(1)

        self._sock.setblocking(1)
        self._sock.settimeout(1)

    def recv(self, bufsize, flags=False):
        try:
            return self._sock.recv(bufsize, flags)
        except socket.timeout as errno:
            print "Timed out waiting for socket read"
            sys.exit(1)

    def sendall(self, data):
        return self._sock.sendall(data)

    def setblocking(self, flags=True):
        self._sock.setblocking(flags)

    def settimeout(self, timeout):
        self._sock.settimeout(timeout)


parser = argparse.ArgumentParser(description='ptmctl arguments parser')

c = PtmClient()
sockaddr_in_len=c_int32(16)
libc_handle = cdll.LoadLibrary('libc.so.6')
sadd=sockaddr_in()
sadd.sin_len = 16
sadd.sin_family = socket.AF_INET
sadd.sin_addr = 0xA00000A
#rc=libc_handle.getsockopt(c_int32(c._sock.fileno()),
#        socket.SOL_IP,80, pointer(sadd), pointer(sockaddr_in_len))

packet = string_at(addressof(sadd), sockaddr_in_len)

payload = packet + "swp1"
print payload
c.sendall(payload)

#c.ptm_get_dump_status()

c.close()


