/*********************************************************************
 * Copyright 2015 Cumulus Networks, LLC.  All rights reserved.
 *
 * library file used by clients for sending commands and parsing response
 *
 */

#ifndef CLAG_H__
#define CLAG_H__

#include "include/openvswitch/shash.h"

bool clag_status(bool *clag_enabled, bool *peerisalive);
void get_clag_bonds(struct shash *b2c, struct shash *c2b);
void update_mgmt_internal_addr(char *remote, bool active, bool clag_enabled);
void update_mgmt_external_redirect(char *remote, bool active);
void backup_db_from_remote(char *remote, char *path);
void update_bfd_redirect(char *remote, bool active);
char *get_clag_vxlan_anycast_ip(void);
char *get_clag_vxlan_peerlink_name(void);
char *get_clag_vxlan_peerlink(void);
char *get_clag_vxlan_peer_clag_ip(void);
#endif
