#include <netlink/netlink.h>
#include <netlink/cache.h>
#include <netlink/cli/utils.h>
#include <signal.h>

static int quit = 0;

static struct nl_dump_params dp = {
	.dp_type = NL_DUMP_LINE,
};


static void change_cb(struct nl_cache *cache, struct nl_object *obj,
		      int action, void *data)
{
	if (action == NL_ACT_NEW)
		printf("NEW ");
	else if (action == NL_ACT_DEL)
		printf("DEL ");
	else if (action == NL_ACT_CHANGE)
		printf("CHANGE ");

	nl_object_dump(obj, &dp);
}

static void sigint(int arg)
{
	quit = 1;
}

int main(int argc, char *argv[])
{
	struct nl_cache_mngr *mngr;
	struct nl_cache *cache;
	struct nl_sock *sync_sock;
	int err;

	dp.dp_fd = stdout;

	signal(SIGINT, sigint);

	err = nl_cache_mngr_alloc(NULL, NETLINK_ROUTE, NL_AUTO_PROVIDE, &mngr);
	if (err < 0)
		nl_cli_fatal(err, "Unable to allocate cache manager: %s",
			     nl_geterror(err));

	if ((err = nl_cache_alloc_name("route/link", &cache)) < 0) {
            nl_cli_fatal(err, "Couldn't add link cache: %s\n", nl_geterror(err));
	}

	sync_sock = nl_cache_mngr_get_sync_sock(mngr);
	/* set cache manager sync sock to 32k */
	nl_socket_set_msg_buf_size(sync_sock, 32768);

	/* set sync socket buffer size to 2MB */
	nl_socket_set_buffer_size(sync_sock, 2 * 1024 * 1024, 2 * 1024 * 1024);

	/* Make link cache iter over all supported families. We need this for
	 * AF_BRIDGE
	 */
	nl_cache_set_flags(cache, NL_CACHE_AF_ITER);
	if ((err = nl_cache_mngr_add_cache(mngr, cache,
					   &change_cb, NULL)) < 0) {
		nl_cli_fatal(err, "Unable to add cache route/link: %s",
			     nl_geterror(err));
	}

	while (!quit) {
		int err = nl_cache_mngr_poll(mngr, 1000);
		if (err < 0 && err != -NLE_INTR)
			nl_cli_fatal(err, "Polling failed: %s", nl_geterror(err));

		nl_cache_mngr_info(mngr, &dp);
	}

	nl_cache_mngr_free(mngr);

	return 0;
}
