/*
 * src/nl-mdb-list.c     List multicast database
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2015 Cumulus Networks. All rights reserved.
 */

#include <netlink/cli/utils.h>
#include <netlink/cli/mdb.h>
#include <netlink/cli/link.h>

static void print_usage(void)
{
	printf(
	"Usage: nl-mdb-list [OPTION]... [MDB]\n"
	"\n"
	"Options\n"
	" -f, --format=TYPE	Output format { brief | details | stats }\n"
	" -h, --help            Show this help\n"
	" -v, --version		Show versioning information\n"
	"\n"
	"MDB Options\n"
	" -d, --dev=DEV         Device the entry is connected to\n"
	);
	exit(0);
}

int main(int argc, char *argv[])
{
	struct nl_sock *sock;
	struct rtnl_mdb *mdb;
	struct nl_cache *link_cache, *mdb_cache;
	struct nl_dump_params params = {
		.dp_fd = stdout,
		.dp_type = NL_DUMP_LINE,
	};

	sock = nl_cli_alloc_socket();
	nl_cli_connect(sock, NETLINK_ROUTE);
	link_cache = nl_cli_link_alloc_cache_flags(sock, NL_CACHE_AF_ITER);
	mdb = nl_cli_mdb_alloc();

	for (;;) {
		int c, optidx = 0;
		static struct option long_opts[] = {
			{ "format", 1, 0, 'f' },
			{ "help", 0, 0, 'h' },
			{ "version", 0, 0, 'v' },
			{ "dev", 1, 0, 'd' },
			{ 0, 0, 0, 0 }
		};

		c = getopt_long(argc, argv, "f:hvd:", long_opts, &optidx);
		if (c == -1)
			break;

		switch (c) {
		case 'f': params.dp_type = nl_cli_parse_dumptype(optarg); break;
		case 'h': print_usage(); break;
		case 'v': nl_cli_print_version(); break;
		case 'd': nl_cli_mdb_parse_dev(mdb, link_cache, optarg); break;
		}
	}

	mdb_cache = nl_cli_mdb_alloc_cache(sock);

	nl_cache_dump_filter(mdb_cache, &params, OBJ_CAST(mdb));

	return 0;
}
