/*
 * src/lib/mdb.c     CLI MDB Helpers
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2015 Cumulus Networks. All rights reserved.
 */

/**
 * @ingroup cli
 * @defgroup cli_mdb MDB
 *
 * @{
 */

#include <netlink/cli/utils.h>
#include <netlink/cli/mdb.h>

struct rtnl_mdb *nl_cli_mdb_alloc(void)
{
	struct rtnl_mdb *mdb;

	mdb = rtnl_mdb_alloc();
	if (!mdb)
		nl_cli_fatal(ENOMEM, "Unable to allocate mdb object");

	return mdb;
}

void nl_cli_mdb_parse_dev(struct rtnl_mdb *mdb,
			  struct nl_cache *link_cache, char *arg)
{
	int ival;

	if (!(ival = rtnl_link_name2i(link_cache, arg)))
		nl_cli_fatal(ENOENT, "Link \"%s\" does not exist", arg);

	rtnl_mdb_set_brifindex(mdb, ival);
}

/** @} */
