/*
 * netlink/route/mroute.h	Multicast Routes
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 */

#ifndef NETLINK_MROUTE_H_
#define NETLINK_MROUTE_H_

#include <netlink/netlink.h>
#include <netlink/cache.h>
#include <netlink/addr.h>
#include <netlink/data.h>
#include <netlink/route/nexthop.h>
#include <netlink/route/rtnl.h>
#include <linux/in_route.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @ingroup route
 * When passed to rtnl_route_alloc_cache() the cache will
 * correspond to the contents of the routing cache instead
 * of the actual routes.
 */
#define ROUTE_CACHE_CONTENT	1

struct rtnl_route;

struct rtnl_mfc_stats
{
};

extern struct nl_object_ops mroute_obj_ops;

extern struct rtnl_route *rtnl_mroute_alloc(void);
extern void rtnl_mroute_get(struct rtnl_route *route);
extern void rtnl_mroute_put(struct rtnl_route *route);

#ifdef __cplusplus
}
#endif

#endif
