/*
 * netlink/route/mpls.h	Routes
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2015-2016 Roopa Prabhu <roopa@cumulusnetworks.com>
 */

#ifndef NETLINK_MPLS_H_
#define NETLINK_MPLS_H_

#include <netlink/netlink.h>
#include <netlink/cache.h>
#include <netlink/addr.h>
#include <netlink/data.h>

#ifdef __cplusplus
extern "C" {
#endif

int nla_put_labels(struct nl_msg *msg, int attrtype,
		   uint32_t num_labels, uint32_t *label);

/* caller needs to free memory allocated for labels */
int nla_get_labels(int len, const void *data,
		   uint32_t *num_labels, uint32_t **label);

#ifdef __cplusplus
}
#endif

#endif
