/*
 * netlink/route/lwt/mpls.h	mpls lwt interface
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2015-2016 Roopa Prabhu <roopa@cumulusnetworks.com>
 */

#ifndef NETLINK_LWT_MPLS_H_
#define NETLINK_LWT_MPLS_H_

#include <netlink/netlink.h>
#include <netlink/route/lwt.h>
#include <netlink/route/mpls.h>

#ifdef __cplusplus
extern "C" {
#endif

struct mpls_iptunnel_encap {
	uint32_t	num_labels;
	uint32_t	*labels;
};

#ifdef __cplusplus
}
#endif

extern void mpls_dump(struct rtnl_lwt_encap *e);

extern int rtnl_lwt_is_mpls(struct rtnl_lwt_encap *e);
extern void rtnl_lwt_mpls_get_labels(struct rtnl_lwt_encap *e,
		 uint32_t max_labels, uint32_t *num_labels, uint32_t *labels);

#endif
