/*
 * netlink/route/lwt/api.h	lwt API
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2015-2016 Roopa Prabhu <roopa@cumulusnetworks.com>
 */

#ifndef NETLINK_LWT_API_H_
#define NETLINK_LWT_API_H_

#include <netlink/netlink.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @ingroup lwt_api
 *
 * Available operations to modules implementing a link info type.
 */
struct rtnl_lwt_ops
{
	/** type of lwt */
	int		lwt_type;

	/** Reference count, DO NOT MODIFY */
	int		lwt_refcnt;

	/** Called to build lwtunnel state */
	int		(*lwt_build_encap)(struct nlattr *encap,
				       struct rtnl_lwt_encap **ts);

	/** Called to compare lwt encap parameters between two encaps. */
	int	      (*lwt_compare_encap)(struct rtnl_lwt_encap *,
				struct rtnl_lwt_encap *, uint16_t type,
				uint32_t attrs,
				int flags);

	/** Called to dump lwtunnel state */
	void		(*lwt_dump_encap)(struct rtnl_lwt_encap *encap,
					  struct nl_dump_params *dp);

	struct rtnl_lwt_encap *(*lwt_clone_encap)(struct rtnl_lwt_encap *encap);
	void		(*lwt_release_encap)(struct rtnl_lwt_encap *encap);
};

extern struct rtnl_lwt_ops *	rtnl_lwt_ops_lookup(const uint16_t type);
extern void			rtnl_lwt_ops_put(struct rtnl_lwt_ops *);
extern int			rtnl_lwt_ops_register(struct rtnl_lwt_ops *);
extern int			rtnl_lwt_ops_unregister(struct rtnl_lwt_ops *);
extern int			rtnl_lwt_compare_encap(struct rtnl_lwt_encap *a,
						struct rtnl_lwt_encap *b);
extern void			rtnl_lwt_dump_encap(struct rtnl_lwt_encap *a,
						    struct nl_dump_params *p);
extern int			rtnl_lwt_build_encap(struct nlattr *nlattr,
						     uint16_t encap_type,
			                             struct rtnl_lwt_encap
						     **encap);
extern struct rtnl_lwt_encap *	rtnl_lwt_clone_encap(struct rtnl_lwt_encap *encap);
extern void			rtnl_lwt_release_encap(struct rtnl_lwt_encap *encap);


#endif
