/*
 * netlink/route/link/mlx_sx_netdev.h          mlx_sx_netdev interface
 *
 *     This library is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License as published by the Free Software Foundation version 2.1
 *     of the License.
 *
 * Copyright (c) 2016 Cumulus Networks. All rights reserved.
 * Copyright (c) 2016 Andy Gospodarek <gospo@cumulusnetworks.com>
 * Copyright (c) 2016 Roopa Prabhu <roopa@cumulusnetworks.com>
 * Copyright (c) 2017 Andy Roulin <aroulin@cumulusnetworks.com>
 */

#ifndef NETLINK_LINK_MLX_SX_NETDEV_H_
#define NETLINK_LINK_MLX_SX_NETDEV_H_

#include <netlink/netlink.h>
#include <netlink/route/link.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct rtnl_link *rtnl_link_mlx_sx_netdev_alloc(void);
extern int rtnl_link_is_mlx_sx_netdev(struct rtnl_link *link);
extern int rtnl_link_mlx_sx_netdev_set_unit(struct rtnl_link *link, uint32_t unit);
extern int rtnl_link_mlx_sx_netdev_set_port(struct rtnl_link *link, uint32_t port);

#ifdef __cplusplus
}
#endif

#endif
