/*
 * netlink/route/link/bridge.h		Bridge
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation version 2.1
 *	of the License.
 *
 * Copyright (c) 2013 Thomas Graf <tgraf@suug.ch>
 */

#ifndef NETLINK_LINK_BRIDGE_H_
#define NETLINK_LINK_BRIDGE_H_

#include <netlink/netlink.h>
#include <netlink/route/link.h>

#ifdef __cplusplus
extern "C" {
#endif

#define BR_SPH_LIST_SIZE 10
#define RTNL_LINK_BRIDGE_VLAN_BITMAP_MAX 4096
#define RTNL_LINK_BRIDGE_VLAN_BITMAP_LEN \
	(RTNL_LINK_BRIDGE_VLAN_BITMAP_MAX / (sizeof(unsigned long) * 8))

struct rtnl_link_bridge_vlan
{
	uint16_t pvid;
	unsigned long vlan_bitmap[RTNL_LINK_BRIDGE_VLAN_BITMAP_LEN];
	unsigned long untagged_bitmap[RTNL_LINK_BRIDGE_VLAN_BITMAP_LEN];
};

struct rtnl_link_bridge_vlan_tunnel
{
	struct nl_list_head rbvt_list;
	uint16_t rbvt_vid;
	uint32_t rbvt_tunid;
};

/**
 * Bridge flags
 * @ingroup bridge
 */
enum rtnl_link_bridge_flags {
	RTNL_BRIDGE_HAIRPIN_MODE	= 0x0001,
	RTNL_BRIDGE_BPDU_GUARD		= 0x0002,
	RTNL_BRIDGE_ROOT_BLOCK		= 0x0004,
	RTNL_BRIDGE_FAST_LEAVE		= 0x0008,
	RTNL_BRIDGE_LEARNING		= 0x0010,
	RTNL_BRIDGE_UNICAST_FLOOD	= 0x0020,
	RTNL_BRIDGE_VLAN_TUNNEL		= 0x0040,
	RTNL_BRIDGE_PEER_LINK		= 0x1000,
	RTNL_BRIDGE_DUAL_LINK		= 0x2000,
	RTNL_BRIDGE_NEIGH_SUPPRESS	= 0x4000,
	RTNL_BRIDGE_BLOCK_BUM		= 0x8000,
};

extern struct rtnl_link *rtnl_link_bridge_alloc(void);

extern int	rtnl_link_is_bridge(struct rtnl_link *);
extern int	rtnl_link_bridge_has_ext_info(struct rtnl_link *);

extern int	rtnl_link_bridge_set_port_state(struct rtnl_link *, uint8_t );
extern int	rtnl_link_bridge_get_port_state(struct rtnl_link *);

extern int	rtnl_bridge_get_backup_port(struct rtnl_link *);

extern uint32_t	rtnl_link_bridge_get_port_backup_nhid(struct rtnl_link *link);

extern int	rtnl_bridge_get_sph_filter_list(struct rtnl_link *link,
						uint32_t *sph_arr);

extern int	rtnl_link_bridge_set_priority(struct rtnl_link *, uint16_t);
extern int	rtnl_link_bridge_get_priority(struct rtnl_link *);

extern int	rtnl_link_bridge_set_cost(struct rtnl_link *, uint32_t);
extern int	rtnl_link_bridge_get_cost(struct rtnl_link *, uint32_t *);

extern int	rtnl_link_bridge_unset_flags(struct rtnl_link *, unsigned int);
extern int	rtnl_link_bridge_set_flags(struct rtnl_link *, unsigned int);
extern int	rtnl_link_bridge_get_flags(struct rtnl_link *);

extern char * rtnl_link_bridge_flags2str(int, char *, size_t);
extern int	rtnl_link_bridge_str2flags(const char *);

extern int	rtnl_link_bridge_add(struct nl_sock *sk, const char *name);

extern int	rtnl_link_bridge_pvid(struct rtnl_link *link);
extern int	rtnl_link_bridge_has_vlan(struct rtnl_link *link);

extern struct rtnl_link_bridge_vlan *rtnl_link_bridge_get_port_vlan(struct rtnl_link *link);
extern struct nl_list_head *rtnl_link_bridge_get_port_vlan_tunnels(
	struct rtnl_link *link);

extern int	rtnl_link_bridge_get_vlan_filtering(struct rtnl_link *link);
extern int	rtnl_link_bridge_get_vlan_protocol(struct rtnl_link *link);
extern int	rtnl_link_bridge_get_ageing_time(struct rtnl_link *link);
extern int  rtnl_link_bridge_get_mcast_snooping(struct rtnl_link *link);
#ifdef __cplusplus
}
#endif

#endif

