/*
 * netlink/route/link/bcm_knet.h          bcm_knet interface
 *
 *     This library is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU Lesser General Public
 *     License as published by the Free Software Foundation version 2.1
 *     of the License.
 *
 * Copyright (c) 2015 Cumulus Networks. All rights reserved.
 * Copyright (c) 2015 Andy Gospodarek <gospo@cumulusnetworks.com>
 * Copyright (c) 2015 Roopa Prabhu <roopa@cumulusnetworks.com>
 */

#ifndef NETLINK_LINK_BCM_KNET_H_
#define NETLINK_LINK_BCM_KNET_H_

#include <netlink/netlink.h>
#include <netlink/route/link.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
	IFLA_KNET_UNSPEC,
	IFLA_KNET_UNIT,
	__IFLA_KNET_MAX
};

#define IFLA_KNET_MAX (__IFLA_KNET_MAX - 1)

extern struct rtnl_link *rtnl_link_bcm_knet_alloc(void);
extern int rtnl_link_is_bcm_knet(struct rtnl_link *link);
extern int rtnl_link_bcm_knet_set_unit(struct rtnl_link *link, uint32_t unit);

#ifdef __cplusplus
}
#endif

#endif
