/*
 *	"TRICOLORPOLICE" target extension for Xtables
 *	Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	version 2 or later, as published by the Free Software Foundation.
 */
#include <linux/ip.h>
#include <linux/module.h>
#include <linux/percpu.h>
#include <linux/route.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <net/checksum.h>
#include <net/icmp.h>
#include <net/ip.h>
#include <net/ipv6.h>
#include <net/ip6_route.h>
#include <net/route.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter/xt_TRICOLORPOLICE.h>

struct xt_tricolor_police_priv {
	struct notifier_block	notifier;
	struct xt_tricolor_police_tginfo	*tginfo;
};

static unsigned int
tricolor_police_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return NF_ACCEPT;
}

static int tricolor_police_tg_check(const struct xt_tgchk_param *par)
{
	struct xt_tricolor_police_tginfo *info = par->targinfo;

	if ((info->bitmask & XT_TRICOLOR_POLICE_CIR) &&
	    (info->cir < XT_TRICOLOR_POLICE_MIN_CIR ||
	     info->cir > XT_TRICOLOR_POLICE_MAX_CIR))
		return -EINVAL;

	if ((info->bitmask & XT_TRICOLOR_POLICE_CBS) &&
	    (info->cbs < XT_TRICOLOR_POLICE_MIN_CBS ||
	     info->cbs > XT_TRICOLOR_POLICE_MAX_CBS))
		return -EINVAL;

	if ((info->bitmask & XT_TRICOLOR_POLICE_PIR) &&
	    (info->pir < XT_TRICOLOR_POLICE_MIN_PIR ||
	     info->pir > XT_TRICOLOR_POLICE_MAX_PIR))
		return -EINVAL;

	if ((info->bitmask & XT_TRICOLOR_POLICE_EBS) &&
	    (info->ebs < XT_TRICOLOR_POLICE_MIN_EBS ||
	     info->ebs > XT_TRICOLOR_POLICE_MAX_EBS))
		return -EINVAL;

	return 0;
}

static void tricolor_police_tg_destroy(const struct xt_tgdtor_param *par)
{
}

static struct xt_target tricolor_police_tg_reg[] __read_mostly = {
	{
		.name       = "TRICOLORPOLICE",
		.revision   = 1,
		.family     = NFPROTO_UNSPEC,
		.target     = tricolor_police_tg,
		.targetsize = sizeof(struct xt_tricolor_police_tginfo),
		.checkentry = tricolor_police_tg_check,
		.destroy    = tricolor_police_tg_destroy,
		.me         = THIS_MODULE,
	},
};

static int __init tricolor_police_tg_init(void)
{
	return xt_register_targets(tricolor_police_tg_reg,
				   ARRAY_SIZE(tricolor_police_tg_reg));
}

static void __exit tricolor_police_tg_exit(void)
{
	xt_unregister_targets(tricolor_police_tg_reg,
			      ARRAY_SIZE(tricolor_police_tg_reg));
}

module_init(tricolor_police_tg_init);
module_exit(tricolor_police_tg_exit);
MODULE_AUTHOR("James Li <jli@cumulusnetworks.com>");
MODULE_DESCRIPTION("Xtables: TriColorPolicing");
MODULE_LICENSE("GPL");
MODULE_ALIAS("ipt_TRICOLORPOLICE");
MODULE_ALIAS("ip6t_TRICOLORPOLICE");
