/*
 *	"SPAN" target extension for Xtables
 *	Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	version 2 or later, as published by the Free Software Foundation.
 */
#include <linux/ip.h>
#include <linux/module.h>
#include <linux/percpu.h>
#include <linux/route.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <net/checksum.h>
#include <net/icmp.h>
#include <net/ip.h>
#include <net/ipv6.h>
#include <net/ip6_route.h>
#include <net/route.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter/xt_SPAN.h>

struct xt_span_priv {
	struct notifier_block	notifier;
	struct xt_span_tginfo	*tginfo;
};

static unsigned int
span_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return XT_CONTINUE;
}

static int span_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static void span_tg_destroy(const struct xt_tgdtor_param *par)
{
}

static struct xt_target span_tg_reg[] __read_mostly = {
	{
		.name       = "SPAN",
		.revision   = 1,
		.family     = NFPROTO_UNSPEC,
		.target     = span_tg,
		.targetsize = sizeof(struct xt_span_tginfo),
		.checkentry = span_tg_check,
		.destroy    = span_tg_destroy,
		.me         = THIS_MODULE,
	},
};

static int __init span_tg_init(void)
{
	return xt_register_targets(span_tg_reg, ARRAY_SIZE(span_tg_reg));
}

static void __exit span_tg_exit(void)
{
	xt_unregister_targets(span_tg_reg, ARRAY_SIZE(span_tg_reg));
}

module_init(span_tg_init);
module_exit(span_tg_exit);
MODULE_AUTHOR("Wilson Kok <wkok@cumulusnetworks.com>");
MODULE_DESCRIPTION("Xtables: Switch Port Analyzer");
MODULE_LICENSE("GPL");
MODULE_ALIAS("ipt_SPAN");
MODULE_ALIAS("ip6t_SPAN");
