/*
 * "SETQOS" target extension for Xtables
 * Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/ip.h>
#include <net/checksum.h>

#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_ipv6.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter/xt_SETQOS.h>
#include <linux/netfilter_arp.h>

static unsigned int
setqos_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return NF_ACCEPT;
}

static int setqos_tg_check(const struct xt_tgchk_param *par)
{
	struct xt_setqos_target_info *info = par->targinfo;

	if (info->cos < XT_SETQOS_MIN_COS || info->cos > XT_SETQOS_MAX_COS)
		return -EINVAL;

	if (info->dscp > XT_SETQOS_DSCP_MAX) {
		pr_info("dscp %x out of range\n", info->dscp);
		return -EDOM;
	}

	return 0;
}

static void setqos_tg_destroy(const struct xt_tgdtor_param *par)
{
}

static struct xt_target setqos_tg_reg[] __read_mostly = {
	{
		.name       = "SETQOS",
		.revision   = 1,
		.family     = NFPROTO_UNSPEC,
		.target     = setqos_tg,
		.targetsize = sizeof(struct xt_setqos_target_info),
		.checkentry = setqos_tg_check,
		.destroy    = setqos_tg_destroy,
		.me         = THIS_MODULE,
	},
};

static int __init setqos_tg_init(void)
{
	return xt_register_targets(setqos_tg_reg, ARRAY_SIZE(setqos_tg_reg));
}

static void __exit setqos_tg_exit(void)
{
	xt_unregister_targets(setqos_tg_reg, ARRAY_SIZE(setqos_tg_reg));
}

module_init(setqos_tg_init);
module_exit(setqos_tg_exit);
MODULE_AUTHOR("Vidya Ravipati <vidya@cumulusnetworks.com>");
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Xtables: Ingress classification");
MODULE_ALIAS("ipt_SETQOS");
MODULE_ALIAS("ip6t_SETQOS");
