/*
 *	"POLICE" target extension for Xtables
 *	Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	version 2 or later, as published by the Free Software Foundation.
 */
#include <linux/ip.h>
#include <linux/module.h>
#include <linux/percpu.h>
#include <linux/route.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <net/checksum.h>
#include <net/icmp.h>
#include <net/ip.h>
#include <net/ipv6.h>
#include <net/ip6_route.h>
#include <net/route.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter/xt_POLICE.h>

struct xt_police_priv {
	struct notifier_block	notifier;
	struct xt_police_tginfo	*tginfo;
};

static unsigned int
police_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return XT_CONTINUE;
}

static int police_tg_check(const struct xt_tgchk_param *par)
{
	struct xt_police_tginfo *info = par->targinfo;

	if (info->class > XT_POLICE_MAX_CLASS)
		return -EINVAL;
	if (info->rate < XT_POLICE_MIN_RATE || info->rate > XT_POLICE_MAX_RATE)
		return -EINVAL;
	if (info->burst < XT_POLICE_MIN_BURST ||
	    info->burst > XT_POLICE_MAX_BURST)
		return -EINVAL;

	return 0;
}

static void police_tg_destroy(const struct xt_tgdtor_param *par)
{
}

static struct xt_target police_tg_reg[] __read_mostly = {
	{
		.name       = "POLICE",
		.revision   = 1,
		.family     = NFPROTO_UNSPEC,
		.target     = police_tg,
		.targetsize = sizeof(struct xt_police_tginfo),
		.checkentry = police_tg_check,
		.destroy    = police_tg_destroy,
		.me         = THIS_MODULE,
	},
};

static int __init police_tg_init(void)
{
	return xt_register_targets(police_tg_reg, ARRAY_SIZE(police_tg_reg));
}

static void __exit police_tg_exit(void)
{
	xt_unregister_targets(police_tg_reg, ARRAY_SIZE(police_tg_reg));
}

module_init(police_tg_init);
module_exit(police_tg_exit);
MODULE_AUTHOR("Wilson Kok <wkok@cumuusnetworks.com>");
MODULE_DESCRIPTION("Xtables: Policing");
MODULE_LICENSE("GPL");
MODULE_ALIAS("ipt_POLICE");
MODULE_ALIAS("ip6t_POLICE");
