/*
 *  ebt_tricolorpolice
 *
 *  Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	Authors:
 *	James Li <jli@cumulusnetworks.com>
 *
 */
#include <linux/module.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netfilter_bridge/ebt_tricolorpolice.h>

static unsigned int
ebt_tricolorpolice_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return EBT_ACCEPT;
}

static int ebt_tricolorpolice_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static struct xt_target ebt_tricolorpolice_tg_reg __read_mostly = {
	.name		= "tricolorpolice",
	.revision	= 0,
	.family		= NFPROTO_BRIDGE,
	.hooks		= (1 << NF_BR_NUMHOOKS) | (1 << NF_BR_LOCAL_IN) |
			  (1 << NF_BR_FORWARD),
	.target		= ebt_tricolorpolice_tg,
	.checkentry	= ebt_tricolorpolice_tg_check,
	.targetsize	= sizeof(struct ebt_tricolor_police_info),
	.me		= THIS_MODULE,
};

static int __init ebt_tricolorpolice_init(void)
{
	return xt_register_target(&ebt_tricolorpolice_tg_reg);
}

static void __exit ebt_tricolorpolice_fini(void)
{
	xt_unregister_target(&ebt_tricolorpolice_tg_reg);
}

module_init(ebt_tricolorpolice_init);
module_exit(ebt_tricolorpolice_fini);
MODULE_DESCRIPTION("Ebtables: Packet three color policing support");
MODULE_LICENSE("GPL");
