/*
 *  ebt_span
 *
 *  Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	Authors:
 *	Wilson Kok <wkok@cumulusnetworks.com>
 */
#include <linux/module.h>
#include <net/sock.h>
#include "../br_private.h"
#include <linux/netfilter.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netfilter_bridge/ebt_span.h>

static unsigned int
ebt_span_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return EBT_CONTINUE;
}

static int ebt_span_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static struct xt_target ebt_span_tg_reg __read_mostly = {
	.name		= "span",
	.revision	= 0,
	.family		= NFPROTO_BRIDGE,
	.hooks		= (1 << NF_BR_NUMHOOKS) | (1 << NF_BR_LOCAL_IN) |
			  (1 << NF_BR_FORWARD) | (1 << NF_BR_LOCAL_OUT),
	.target		= ebt_span_tg,
	.checkentry	= ebt_span_tg_check,
	.targetsize	= sizeof(struct ebt_span_info),
	.me		= THIS_MODULE,
};

static int __init ebt_span_init(void)
{
	return xt_register_target(&ebt_span_tg_reg);
}

static void __exit ebt_span_fini(void)
{
	xt_unregister_target(&ebt_span_tg_reg);
}

module_init(ebt_span_init);
module_exit(ebt_span_fini);
MODULE_DESCRIPTION("Ebtables: Switch Port Analyzer");
MODULE_LICENSE("GPL");
