/*
 *  ebt_setqos
 *
 *  Copyright 2016 Cumulus Networks, Inc.  All rights reserved.
 *
 *	Authors:
 *	Balakrishnan Ramamn <ramanb@cumulusnetworks.com>
 *
 */
#include <linux/module.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netfilter_bridge/ebt_setqos.h>

static unsigned int
ebt_setqos_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return EBT_ACCEPT;
}

static int ebt_setqos_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static struct xt_target ebt_setqos_tg_reg __read_mostly = {
	.name		= "setqos",
	.revision	= 0,
	.family		= NFPROTO_BRIDGE,
	.hooks		= (1 << NF_BR_NUMHOOKS) | (1 << NF_BR_LOCAL_IN) |
			  (1 << NF_BR_FORWARD),
	.target		= ebt_setqos_tg,
	.checkentry	= ebt_setqos_tg_check,
	.targetsize	= sizeof(struct ebt_setqos_info),
	.me		= THIS_MODULE,
};

static int __init ebt_setqos_init(void)
{
	return xt_register_target(&ebt_setqos_tg_reg);
}

static void __exit ebt_setqos_fini(void)
{
	xt_unregister_target(&ebt_setqos_tg_reg);
}

module_init(ebt_setqos_init);
module_exit(ebt_setqos_fini);
MODULE_DESCRIPTION("Ebtables: CoS/DSCP remarking");
MODULE_LICENSE("GPL");
