/*
 *  ebt_setclass
 *
 *  Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	Authors:
 *	Wilson Kok <wkok@cumulusnetworks.com>
 *
 */
#include <linux/module.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netfilter_bridge/ebt_setclass.h>

static unsigned int
ebt_setclass_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return EBT_ACCEPT;
}

static int ebt_setclass_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static struct xt_target ebt_setclass_tg_reg __read_mostly = {
	.name		= "setclass",
	.revision	= 0,
	.family		= NFPROTO_BRIDGE,
	.hooks		= (1 << NF_BR_NUMHOOKS) | (1 << NF_BR_LOCAL_IN) |
			  (1 << NF_BR_FORWARD),
	.target		= ebt_setclass_tg,
	.checkentry	= ebt_setclass_tg_check,
	.targetsize	= sizeof(struct ebt_setclass_info),
	.me		= THIS_MODULE,
};

static int __init ebt_setclass_init(void)
{
	return xt_register_target(&ebt_setclass_tg_reg);
}

static void __exit ebt_setclass_fini(void)
{
	xt_unregister_target(&ebt_setclass_tg_reg);
}

module_init(ebt_setclass_init);
module_exit(ebt_setclass_fini);
MODULE_DESCRIPTION("Ebtables: Ingress classification");
MODULE_LICENSE("GPL");
