/*
 *  ebt_police
 *
 *  Copyright 2013 Cumulus Networks, LLC.  All rights reserved.
 *
 *	Authors:
 *	Wilson Kok <wkok@cumulusnetworks.com>
 *
 */
#include <linux/module.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter_bridge/ebtables.h>
#include <linux/netfilter_bridge/ebt_police.h>

static unsigned int
ebt_police_tg(struct sk_buff *skb, const struct xt_action_param *par)
{
	return EBT_ACCEPT;
}

static int ebt_police_tg_check(const struct xt_tgchk_param *par)
{
	return 0;
}

static struct xt_target ebt_police_tg_reg __read_mostly = {
	.name		= "police",
	.revision	= 0,
	.family		= NFPROTO_BRIDGE,
	.hooks		= (1 << NF_BR_NUMHOOKS) | (1 << NF_BR_LOCAL_IN) |
			  (1 << NF_BR_FORWARD),
	.target		= ebt_police_tg,
	.checkentry	= ebt_police_tg_check,
	.targetsize	= sizeof(struct ebt_police_info),
	.me		= THIS_MODULE,
};

static int __init ebt_police_init(void)
{
	return xt_register_target(&ebt_police_tg_reg);
}

static void __exit ebt_police_fini(void)
{
	xt_unregister_target(&ebt_police_tg_reg);
}

module_init(ebt_police_init);
module_exit(ebt_police_fini);
MODULE_DESCRIPTION("Ebtables: Packet policing support");
MODULE_LICENSE("GPL");
