#ifndef __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H
#define __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H

#include <linux/types.h>

#define EBT_TRICOLOR_POLICE_COLOR_MODE            0x01
#define EBT_TRICOLOR_POLICE_CIR                   0x02
#define EBT_TRICOLOR_POLICE_CBS                   0x04
#define EBT_TRICOLOR_POLICE_PIR                   0x08
#define EBT_TRICOLOR_POLICE_EBS                   0x10
#define EBT_TRICOLOR_POLICE_VIOLATE_ACTION        0x20
#define EBT_TRICOLOR_POLICE_CONFORM_ACTION_DSCP   0x40
#define EBT_TRICOLOR_POLICE_EXCEED_ACTION_DSCP    0x80
#define EBT_TRICOLOR_POLICE_VIOLATE_ACTION_DSCP   0x100
#define EBT_TRICOLOR_POLICE_MAX                   0x200

#define EBT_TRICOLOR_POLICE_MASK (EBT_TRICOLOR_POLICE_MAX - 1)

#define EBT_TRICOLOR_POLICE_MIN_CLASS 0
#define EBT_TRICOLOR_POLICE_MAX_CLASS 7

#define EBT_TRICOLOR_POLICE_MIN_CIR  0
#define EBT_TRICOLOR_POLICE_MAX_CIR  0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_CBS 0
#define EBT_TRICOLOR_POLICE_MAX_CBS 0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_PIR  0
#define EBT_TRICOLOR_POLICE_MAX_PIR  0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_EBS 0
#define EBT_TRICOLOR_POLICE_MAX_EBS 0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_COLOR_MODE_BLIND  0
#define EBT_TRICOLOR_POLICE_COLOR_MODE_AWARE  1

/* TRICOLOR_POLICE ACTION */
enum ebt_tricolor_police_action_e {
	EBT_TRICOLOR_POLICE_ACTION_PERMIT = 0,
	EBT_TRICOLOR_POLICE_ACTION_DENY,
	EBT_TRICOLOR_POLICE_ACTION_MAX_FIELD
};

/* Action & DSCP value */
struct ebt_tricolor_police_action {
	enum ebt_tricolor_police_action_e type;
	__u8  dscp_value;
};

struct ebt_tricolor_police_info {
	__u8  color_mode;
	__u32 cir;
	__u32 cbs;
	__u32 pir;
	__u32 ebs;
	__u32 bitmask;

	struct ebt_tricolor_police_action conform_action;
	struct ebt_tricolor_police_action exceed_action;
	struct ebt_tricolor_police_action violate_action;
};
#define EBT_TRICOLORPOLICE_TARGET "tricolorpolice"

#endif /* __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H */
