#ifndef __LINUX_BRIDGE_EBT_POLICE_H
#define __LINUX_BRIDGE_EBT_POLICE_H

#include <linux/types.h>

#define EBT_POLICE_CLASS  0x01
#define EBT_POLICE_RATE   0x02
#define EBT_POLICE_BURST  0x04
#define EBT_POLICE_MODE   0x08
#define EBT_POLICE_MASK (EBT_POLICE_CLASS | EBT_POLICE_RATE | \
			 EBT_POLICE_BURST | EBT_POLICE_MODE)

#define EBT_POLICE_MIN_CLASS 0
#define EBT_POLICE_MAX_CLASS 7

#define EBT_POLICE_MIN_RATE  1
#define EBT_POLICE_MAX_RATE  0xFFFFFFFF

#define EBT_POLICE_MIN_BURST 1
#define EBT_POLICE_MAX_BURST 0xFFFFFFFF

#define EBT_POLICE_MODE_PPS  0
#define EBT_POLICE_MODE_KB   1
#define EBT_POLICE_MODE_MB   2
#define EBT_POLICE_MODE_GB   3

struct ebt_police_info {
	__u8  class;
	__u8  mode;
	__u32 rate;
	__u32 burst;
	__u8  bitmask;
	int target;
};
#define EBT_POLICE_TARGET "police"

#endif
