#ifndef __LINUX_BRIDGE_EBT_ERSPAN_H
#define __LINUX_BRIDGE_EBT_ERSPAN_H

#include <linux/types.h>

#define EBT_ERSPAN_SRC_IP 0x01
#define EBT_ERSPAN_DST_IP 0x02
#define EBT_ERSPAN_TTL    0x04
#define EBT_ERSPAN_PREC   0x08
#define EBT_ERSPAN_MASK (EBT_ERSPAN_SRC_IP | EBT_ERSPAN_DST_IP | \
			 EBT_ERSPAN_TTL | EBT_ERSPAN_PREC)

struct ebt_erspan_info {
	__be32 src_ip;
	__be32 dst_ip;
	__u8 ttl;
	__u8 prec;
	__u8 bitmask;
	int target;
};
#define EBT_ERSPAN_TARGET "erspan"

#endif
