#undef TRACE_SYSTEM
#define TRACE_SYSTEM vxlan

#if !defined(_TRACE_VXLAN_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_VXLAN_H

#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/tracepoint.h>
#include <net/vxlan.h>

TRACE_EVENT(vxlan_fdb_notify,

	TP_PROTO(struct vxlan_dev *vxlan,
		 struct vxlan_fdb *fdb,
		 struct vxlan_rdst *rd, int type),

	TP_ARGS(vxlan, fdb, rd, type),

	TP_STRUCT__entry(
		__string(vxlan_dev, vxlan->dev->name)
		__array(u8, addr, ETH_ALEN)
		__field(u16, state)
		__field(u16, flags)
		__array(unsigned char, remote_ip, sizeof(struct sockaddr_in6))
		__field(u32, remote_vni)
		__field(u32, remote_ifindex)
		__field(u32, type)
	),

	TP_fast_assign(
		__assign_str(vxlan_dev, vxlan->dev->name);
		memcpy(__entry->addr, fdb->eth_addr, ETH_ALEN);
		__entry->state = fdb->state;
		__entry->flags = fdb->flags;
		if (rd) {
			memcpy(__entry->remote_ip, &rd->remote_ip,
			       sizeof(rd->remote_ip));
			__entry->remote_vni = rd->remote_vni;
			__entry->remote_ifindex = rd->remote_ifindex;
		}
		__entry->type = type;
	),

	TP_printk("vxlan_dev %s addr %02x:%02x:%02x:%02x:%02x:%02x state %04x flags %02x remote_ip %pISc remote_vni %u remote_ifindex %u type %d",
		  __get_str(vxlan_dev), __entry->addr[0], __entry->addr[1],
		  __entry->addr[2], __entry->addr[3], __entry->addr[4],
		  __entry->addr[5], __entry->state, __entry->flags,
		  __entry->remote_ip, __entry->remote_vni, __entry->remote_ifindex,
		  __entry->type)
);

#endif /* _TRACE_VXLAN_H */

/* This part must be outside protection */
#include <trace/define_trace.h>
