/* SPDX-License-Identifier: GPL-2.0 */
#undef TRACE_SYSTEM
#define TRACE_SYSTEM ipmr

#if !defined(_TRACE_IPMR_H) || defined(TRACE_HEADER_MULTI_READ)
#define _TRACE_IPMR_H

#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/mroute_base.h>
#include <linux/tracepoint.h>
#include <linux/ip.h>
#include <linux/ipv6.h>

TRACE_EVENT(ipmr_table_lookup,

	TP_PROTO(const struct flowi4 *flp, const struct mr_table *mrt, int err),

	TP_ARGS(flp, mrt, err),

	TP_STRUCT__entry(
		__field(	u32,	tb_id		)
		__field(	int,	err		)
		__field(	int,	oif		)
		__field(	int,	iif		)
		__field(	__u8,	tos		)
		__array(	__u8,	saddr,	4	)
		__array(	__u8,	daddr,	4	)
	),

	TP_fast_assign(
		__be32 *p32;

		__entry->oif = flp->flowi4_oif;
		__entry->iif = flp->flowi4_iif;
		__entry->tos = flp->flowi4_tos;

		p32 = (__be32 *) __entry->saddr;
		*p32 = flp->saddr;

		p32 = (__be32 *) __entry->daddr;
		*p32 = flp->daddr;

		__entry->err = err;
		__entry->tb_id = err == 0 ? mrt->id : 0;
	),

	TP_printk("oif %d iif %d %pI4 -> %pI4 tos %d ==> table %d err %d",
		  __entry->oif, __entry->iif, __entry->saddr, __entry->daddr,
		  __entry->tos, __entry->tb_id, __entry->err)
);

TRACE_EVENT(ipmr_forward,

	TP_PROTO(const struct mr_table *mrt, const struct iphdr *iph,
		 int in_vifi, int out_vifi, struct vif_device *out_vif),

	TP_ARGS(mrt, iph, in_vifi, out_vifi, out_vif),

	TP_STRUCT__entry(
		__field(	u32,	tb_id		)
		__field(	int,	in_vifi		)
		__field(	int,	out_vifi	)
		__field(	int,	link		)
		__field(	__u16,	flags		)
		__dynamic_array(char,  name,   IFNAMSIZ )
		__array(	__u8,	saddr,	4	)
		__array(	__u8,	daddr,	4	)
	),

	TP_fast_assign(
		__be32 *p32;

		__entry->tb_id = mrt->id;
		__entry->in_vifi = in_vifi;
		__entry->out_vifi = out_vifi;
		__entry->link = out_vif->link;
		__entry->flags = out_vif->flags;

		if (out_vif->dev) {
			__assign_str(name, out_vif->dev->name);
		} else {
			__assign_str(name, "-");
		}

		p32 = (__be32 *) __entry->saddr;
		*p32 = iph->saddr;

		p32 = (__be32 *) __entry->daddr;
		*p32 = iph->daddr;
	),

	TP_printk("table %d %pI4 vif %d -> %pI4 vif %d dev %s link %d flags %x",
		  __entry->tb_id, __entry->saddr, __entry->in_vifi,
 		  __entry->daddr, __entry->out_vifi, __get_str(name),
		  __entry->link, __entry->flags)
);

TRACE_EVENT(ip6mr_table_lookup,

	TP_PROTO(const struct flowi6 *flp, const struct mr_table *mrt, int err),

	TP_ARGS(flp, mrt, err),

	TP_STRUCT__entry(
		__field(	u32,	tb_id		)
		__field(	int,	err		)
		__field(	int,	oif		)
		__field(	int,	iif		)
		__array(	__u8,	saddr,	16	)
		__array(	__u8,	daddr,	16	)
	),

	TP_fast_assign(
		struct in6_addr *in6;

		__entry->oif = flp->flowi6_oif;
		__entry->iif = flp->flowi6_iif;

		in6 = (struct in6_addr *)__entry->saddr;
		*in6 = flp->saddr;

		in6 = (struct in6_addr *)__entry->daddr;
		*in6 = flp->daddr;

		__entry->err = err;
		__entry->tb_id = err == 0 ? mrt->id : 0;
	),

	TP_printk("oif %d iif %d %pI6c -> %pI6c ==> table %d err %d",
		  __entry->oif, __entry->iif, __entry->saddr, __entry->daddr,
		  __entry->tb_id, __entry->err)
);

TRACE_EVENT(ip6mr_forward,

	TP_PROTO(const struct mr_table *mrt, const struct ipv6hdr *ip6h,
		 int in_vifi, int out_vifi, struct vif_device *out_vif),

	TP_ARGS(mrt, ip6h, in_vifi, out_vifi, out_vif),

	TP_STRUCT__entry(
		__field(	u32,	tb_id		)
		__field(	int,	in_vifi		)
		__field(	int,	out_vifi	)
		__field(	int,	link		)
		__field(	__u16,	flags		)
		__dynamic_array(char,  name,   IFNAMSIZ )
		__array(	__u8,	saddr,	16	)
		__array(	__u8,	daddr,	16	)
	),

	TP_fast_assign(
		struct in6_addr *in6;

		__entry->tb_id = mrt->id;
		__entry->in_vifi = in_vifi;
		__entry->out_vifi = out_vifi;
		__entry->link = out_vif->link;
		__entry->flags = out_vif->flags;

		if (out_vif->dev) {
			__assign_str(name, out_vif->dev->name);
		} else {
			__assign_str(name, "-");
		}

		in6 = (struct in6_addr *)__entry->saddr;
		*in6 = ip6h->saddr;

		in6 = (struct in6_addr *)__entry->daddr;
		*in6 = ip6h->daddr;
	),

	TP_printk("table %d %pI6c vif %d -> %pI6c vif %d dev %s link %d flags %x",
		  __entry->tb_id, __entry->saddr, __entry->in_vifi,
 		  __entry->daddr, __entry->out_vifi, __get_str(name),
		  __entry->link, __entry->flags)
);
#endif /* _TRACE_IPMR_H */

/* This part must be outside protection */
#include <trace/define_trace.h>
