#ifndef _IPROC_CMIC_H
#define _IPROC_CMIC_H

struct iproc_cmic {
	void __iomem *base;
	struct device *dev;

	const struct sbus_ops *sbus_ops;
};

struct sbus_ops {
	int (*init)(struct iproc_cmic *cmic);
	int	(*reg32_write)(struct iproc_cmic *cmic, u32 block, u32 addr, u32 val);
	u32	(*reg32_read)(struct iproc_cmic *cmic, u32 block, u32 addr);
	int	(*reg64_write)(struct iproc_cmic *cmic, u32 block, u32 addr, u64 val);
	u64	(*reg64_read)(struct iproc_cmic *cmic, u32 block, u32 addr);
	int	(*ucmem_write)(struct iproc_cmic *cmic, u32 block, u32 *mem);
	int (*ucmem_read)(struct iproc_cmic *cmic, u32 block, u32 *mem);
};

enum cmic_block_type {
	CMIC_BLOCK_TYPE_TOP = 0,
	CMIC_BLOCK_TYPE_APM = 1,
};

extern int iproc_cmic_schan_reg32_write(u32 blk_type, u32 addr, u32 val);
extern u32 iproc_cmic_schan_reg32_read(u32 blk_type, u32 addr);
extern int iproc_cmic_schan_reg64_write(u32 blk_type, u32 addr, u64 val);
extern u64 iproc_cmic_schan_reg64_read(u32 blk_type, u32 addr);
extern int iproc_cmic_schan_ucmem_write(u32 blk_type, u32 *mem);
extern int iproc_cmic_schan_ucmem_read(u32 blk_type, u32 *mem);
extern void inline __iomem *iproc_cmic_base_get(void);

#endif /* _IPROC_CMIC_H */
