/*
 *  port.h - defines for generic netlink port handler
 *  Copyright (C) 2015 Cumulus Networks
 */

#ifndef _LINUX_PORT_H
#define _LINUX_PORT_H

#ifdef __KERNEL__
#include <linux/compat.h>
#include <linux/if_bridge.h>
#endif
#include <linux/types.h>

enum {
	PORT_ATTR_UNSPEC,
	PORT_ATTR_STATUS,
	PORT_ATTR_IFINDEX,
	PORT_ATTR_FLAGS,
	PORT_ATTR_CARRIER,
	PORT_ATTR_PHYS_ID_STATE,
	PORT_ATTR_SETTINGS,
	PORT_ATTR_PAUSE,
	PORT_ATTR_MODINFO,
	PORT_ATTR_EEPROM,
	PORT_ATTR_EEPROM_DATA,
	PORT_ATTR_STATS,
	PORT_ATTR_STAT,
	PORT_ATTR_STRINGS,
	PORT_ATTR_STRING,
	PORT_ATTR_SSET,
	PORT_ATTR_SSET_COUNT,
	MC_ATTR_FAMILY,
	MC_ATTR_ARRAY,
	PORT_ATTR_FEC,
	PORT_VSTATS_ATTR_ARRAY,
	PORT_VSTATS_ATTR_OP,
	MC_ATTR_VRF_ARRAY,
	__PORT_ATTR_MAX,
};

#define PORT_ATTR_MAX (__PORT_ATTR_MAX - 1)

enum {
	PORT_CMD_UNSPEC,
	PORT_CMD_REPLY,
	PORT_CMD_GET_SETTINGS,
	PORT_CMD_SET_SETTINGS,
	PORT_CMD_GET_PAUSE,
	PORT_CMD_SET_PAUSE,
	PORT_CMD_GET_MODULE_INFO,
	PORT_CMD_GET_MODULE_EEPROM,
	PORT_CMD_SET_STATS,
	PORT_CMD_GET_STRINGS,
	PORT_CMD_GET_SSET_COUNT,
	PORT_CMD_SET_CARRIER,
	PORT_CMD_SET_PHYS_ID_STATE,
	PORT_CMD_GET_CACHED_SETTINGS,
	MC_CMD_REFRESH_AGE,
	PORT_CMD_GET_FEC,
	PORT_CMD_SET_FEC,
	PORT_CMD_UPDATE_VSTATS,
	PORT_CMD_GET_CACHED_FEC,
	__PORT_CMD_MAX,
};

union mc_addr {
	struct {
		__be32 group;
		__be32 source;
	};
	struct {
		struct in6_addr v6group;
		struct in6_addr v6source;
	};
};

struct mc_addr_vrf {
	union mc_addr mcaddr;
	u32 table;
	u64 unused;
};

#ifdef __KERNEL__

#define PORT_ATTR_FLAG_STAT_RESTART BIT(0)
#define PORT_ATTR_FLAG_CARRIER_SET_QUEUE BIT(1)

void port_init_ethtool_stats(struct net_device *dev);
void port_uninit_ethtool_stats(struct net_device *dev);
int port_get_link_settings(struct net_device *dev, struct ethtool_link_ksettings *link_ksettings);
int port_set_link_settings(struct net_device *dev, const struct ethtool_link_ksettings *link_ksettings);
void port_get_pauseparam(struct net_device *dev,
			 struct ethtool_pauseparam *pause);
int port_set_pauseparam(struct net_device *dev,
			struct ethtool_pauseparam *pause);
void port_get_ethtool_stats(struct net_device *dev,
			    struct ethtool_stats *stats, u64 *data);
void port_get_ethtool_stats_clear(struct net_device *dev,
				  struct ethtool_stats *stats, u64 *data);
void port_get_strings(struct net_device *dev, u32 stringset, u8 *data);
int port_get_sset_count(struct net_device *dev, int sset);
int port_set_phys_id(struct net_device *dev, enum ethtool_phys_id_state state);
int port_get_module_info(struct net_device *dev, struct ethtool_modinfo *info);
int port_get_module_eeprom(struct net_device *dev,
			   struct ethtool_eeprom *eeprom, u8 *data);
int port_get_fecparam(struct net_device *dev,
			 struct ethtool_fecparam *fecparam);
int port_set_fecparam(struct net_device *dev,
			struct ethtool_fecparam *fecparam);
void port_vstats_fetch(struct bridge_vlan_xstats *vstore);
void port_vstats_reset(u16 vid);
bool port_vstats_valid(void);
#endif /* __KERNEL__ */

#endif /* _LINUX_PORT_H */
