/*
 * Copyright (C) 2016 Broadcom Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <asm/mach/arch.h>
#include <linux/io.h>
#include <linux/of.h>
#include <linux/of_platform.h>
#include <linux/dma-mapping.h>
#include <linux/soc/bcm/xgs-iproc-misc-setup.h>
#include <linux/soc/bcm/xgs-iproc-idm.h>

#define DMU_CRU_RESET_BASE 0x200

enum xgs_iproc_dev_id {
	XGS_IPROC_HX4=0,
	XGS_IPROC_KT2,
	XGS_IPROC_HR2,
	XGS_IPROC_GH,
	XGS_IPROC_SB2,
	XGS_IPROC_HR3,
	XGS_IPROC_GH2,
	XGS_IPROC_WH2,
	XGS_IPROC_GENERIC,
};

const char *const xgs_iproc_dt_compat[] = {
	"brcm,helix4",
	"brcm,katana2",
	"brcm,hurricane2",
	"brcm,greyhound",
	"brcm,saber2",
	"brcm,hurricane3",
	"brcm,greyhound2",
	"brcm,wolfhound2",
	"brcm,xgs-iproc",
	"dni,dni_3448p",
	"accton,as4610_54",
	"dni,dni_3048up",
	NULL,
};

void __init xgs_iproc_init_early(void)
{
}

static void __init xgs_iproc_init(void)
{
	int ret;

	ret = xgs_iproc_misc_setup();
	if (ret < 0)
		return;

	/* Init idm and setup idm timeout handler for debug purpose */
	/* xgs_iproc_idm_init should be init before reset dmac */
	ret = xgs_iproc_idm_init();
	if (ret < 0)
		return;

	xgs_iproc_idm_dmac_reset();

	/* Populate platform devices */
	of_platform_populate(NULL, of_default_bus_match_table, NULL, NULL);
}

void (*cpld_system_reset)(void);
EXPORT_SYMBOL(cpld_system_reset); /*  used in dni_3048up_cpld.c module */

static void xgs_iproc_restart(enum reboot_mode mode, const char *cmd)
{
	void * __iomem reg_addr;
	u32 reg;

	if (cpld_system_reset) {
		pr_info("Using CPLD reset\n");
		cpld_system_reset();
	}

	/* CRU_RESET register */
	reg_addr = (void * __iomem)(get_iproc_dmu_pcu_base() +
					DMU_CRU_RESET_BASE);
	/* set iproc_reset_n to 0 */
	reg = readl(reg_addr);
	reg &= ~((u32) 1 << 1);

	writel(reg, reg_addr);

	/* Wait for reset */
	while (1)
		cpu_do_idle();
}

DT_MACHINE_START(XGS_iProc_DT, "BRCM XGS iProc")
	.init_early = xgs_iproc_init_early,
	.init_machine = xgs_iproc_init,
	.dt_compat = xgs_iproc_dt_compat,
	.restart = xgs_iproc_restart,
	.l2c_aux_val    = 0,
	.l2c_aux_mask	= ~0,
MACHINE_END
