#ifndef _XT_POLICE_TARGET_H
#define _XT_POLICE_TARGET_H

#define XT_POLICE_CLASS    0x01
#define XT_POLICE_RATE     0x02
#define XT_POLICE_BURST    0x04
#define XT_POLICE_MODE     0x08
#define XT_POLICE_VIOLATE_ACTION        0x10
#define XT_POLICE_MASK (XT_POLICE_CLASS | XT_POLICE_RATE | XT_POLICE_BURST | \
			XT_POLICE_MODE | XT_POLICE_VIOLATE_ACTION)

#define XT_POLICE_MIN_CLASS 0
#define XT_POLICE_MAX_CLASS 7

#define XT_POLICE_MIN_RATE  1
#define XT_POLICE_MAX_RATE  0xFFFFFFFF

#define XT_POLICE_MIN_BURST 1
#define XT_POLICE_MAX_BURST 0xFFFFFFFF

#define XT_POLICE_MODE_PPS  0
#define XT_POLICE_MODE_KB   1
#define XT_POLICE_MODE_MB   2
#define XT_POLICE_MODE_GB   3

/* POLICE ACTION */
typedef enum {
	XT_POLICE_ACTION_PERMIT = 0,
	XT_POLICE_ACTION_DENY,
	XT_POLICE_ACTION_MAX_FIELD
} xt_police_action_e;

/* Action & DSCP value */
typedef struct xt_police_action {
	xt_police_action_e type;
} xt_police_action_t;


struct xt_police_tginfo {
	__u8  class;
	__u8  mode;
	__u32 rate;
	__u32 burst;
	__u32 bitmask;

	xt_police_action_t violate_action;

	/* used internally by the kernel */
	struct xt_police_priv *priv __attribute__((aligned(8)));
};

#endif /* _XT_POLICE_TARGET_H */
