The TRICOLORPOLICE target provides single rate or two rate three color policing.
To configure a single rate policer, specify CIR, CBS and EBS. To configure a two rate
policer, specify CIR, CBS, PIR and EBS. The policer classifies packets into 3 categories:
conform(green), exceed(yellow) and violate(red).

Green packets are always transmitted, with a low internal drop precedence.
Optionally, a DSCP value can be specified via the set-conform-action-dscp action.
This DSCP value can be used by downstream device for congestion management.

Yellow packets are always transmitted, with a medium internal drop precedence.
Optionally, a DSCP value can be specified via the set-exceed-action-dscp action.
This DSCP value can be used by downstream device for congestion management.

Red packets are by default transmitted, with a high internal drop precedence.
Optionally, a DSCP value can be specified via the set-violate-action-dscp action.
This DSCP value can be used by downstream device for congestion management.
Red packets can be configured to be dropped via the set-violate-action action.

.TP
\fB\-\-set\-color\-mode\fP {\fBblind\fP|\fBaware\fP}
Set the policer to be color blind or color aware. Default is color aware.
.TP
\fB\-\-set\-cir\fP \fIvalue\fP
Specify the committed information rate (CIR) in kbits per second.
.TP
\fB\-\-set\-cbs\fP \fIvalue\fP
Specify the committed burst size (CBS) in kbytes.
.TP
\fB\-\-set\-pir\fP \fIvalue\fP
Specify the peak information rate (PIR) in kbits per second.
.TP
\fB\-\-set\-ebs\fP \fIvalue\fP
Specify the excess burst size (EBS) in kbytes.
.TP
\fB\-\-set\-conform\-action\-dscp\fP \fIvalue\fP
Specify the dscp value to transmit with for packets that conform.
.TP
\fB\-\-set\-exceed\-action\-dscp\fP \fIvalue\fP
Specify the dscp value to transmit with for packets that exceed.
.TP
\fB\-\-set\-violate\-action\-dscp\fP \fIvalue\fP
Specify the dscp value to transmit with for packets that violate.
.TP
\fB\-\-set\-violate\-action\fP {\fBaccept\fP|\fBdrop\fP}
Specify whether to transmit or drop packets that violate.

.PP
Example:
.PP
This configures a 2 rate 3 color policer, with 3 Mbps CIR, 500 KB CBS, 10 Mbps PIR, and 1 MB EBS.
The policer drops red packets.
.PP
\-A INPUT \-\-in\-interface swp1 \-j TRICOLORPOLICE \-\-set\-color\-mode blind \-\-set\-cir 3000 \-\-set\-cbs 500 \-\-set\-pir 10000 \-\-set\-ebs 1000 \-\-set\-violate\-action drop
.PP
Note that the counter for this rule will indicate all packets/bytes that hit the rule irrespective of whether they conformed to the policer rates or not.
