/* Shared library add-on to xtables for OFFLOAD
 *
 * (C) 2021 Nikolay Aleksandrov <nikolay@nvidia.com>
 *
 * This program is distributed under the terms of GNU GPL v2, 1991
 */
#include <stdio.h>
#include <string.h>
#include <xtables.h>

static void offload_help(void)
{
	printf("OFFLOAD target options\n");
}

static void offload_print(const void *ip, const struct xt_entry_target *target,
                      int numeric)
{
	printf(" OFFLOAD ");
}

static struct xtables_target offload_tg_reg = {
	.name		= "OFFLOAD",
	.version	= XTABLES_VERSION,
	.family		= NFPROTO_UNSPEC,
	.size		= XT_ALIGN(0),
	.userspacesize	= XT_ALIGN(0),
	.help		= offload_help,
	.print		= offload_print,
};

void _init(void)
{
	xtables_register_target(&offload_tg_reg);
}
