/* Copyright (C) 2014, 2015, 2017 Cumulus Networks, Inc. All rights reserved
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * https://www.gnu.org/licenses/gpl-2.0-standalone.html
 */

#ifndef __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H
#define __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H

#define EBT_TRICOLOR_POLICE_COLOR_MODE            0x01
#define EBT_TRICOLOR_POLICE_CIR                   0x02
#define EBT_TRICOLOR_POLICE_CBS                   0x04
#define EBT_TRICOLOR_POLICE_PIR                   0x08
#define EBT_TRICOLOR_POLICE_EBS                   0x10
#define EBT_TRICOLOR_POLICE_VIOLATE_ACTION        0x20
#define EBT_TRICOLOR_POLICE_CONFORM_ACTION_DSCP   0x40
#define EBT_TRICOLOR_POLICE_EXCEED_ACTION_DSCP    0x80
#define EBT_TRICOLOR_POLICE_VIOLATE_ACTION_DSCP   0x100
#define EBT_TRICOLOR_POLICE_MAX                   0x200

#define EBT_TRICOLOR_POLICE_MASK (EBT_TRICOLOR_POLICE_MAX - 1)

#define EBT_TRICOLOR_POLICE_MIN_CLASS 0
#define EBT_TRICOLOR_POLICE_MAX_CLASS 7

#define EBT_TRICOLOR_POLICE_MIN_CIR  0
#define EBT_TRICOLOR_POLICE_MAX_CIR  0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_CBS 0
#define EBT_TRICOLOR_POLICE_MAX_CBS 0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_PIR  0
#define EBT_TRICOLOR_POLICE_MAX_PIR  0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_MIN_EBS 0
#define EBT_TRICOLOR_POLICE_MAX_EBS 0xFFFFFFFF

#define EBT_TRICOLOR_POLICE_COLOR_MODE_BLIND  0
#define EBT_TRICOLOR_POLICE_COLOR_MODE_AWARE  1

/* TRICOLOR_POLICE ACTION */
typedef enum {
	EBT_TRICOLOR_POLICE_ACTION_PERMIT = 0,
	EBT_TRICOLOR_POLICE_ACTION_DENY,
	EBT_TRICOLOR_POLICE_ACTION_MAX_FIELD
} ebt_tricolor_police_action_e;

/* Action & DSCP value */
typedef struct ebt_tricolor_police_action {
	ebt_tricolor_police_action_e type;
	__u8  dscp_value;
} ebt_tricolor_police_action_t;

struct ebt_tricolor_police_info {
	__u8  color_mode;
	__u32 cir;
	__u32 cbs;
	__u32 pir;
	__u32 ebs;
	__u32 bitmask;

	ebt_tricolor_police_action_t conform_action;
	ebt_tricolor_police_action_t exceed_action;
	ebt_tricolor_police_action_t violate_action;
};
#define EBT_TRICOLORPOLICE_TARGET "tricolorpolice"

#endif /* __LINUX_BRIDGE_EBT_TRICOLORPOLICE_H */
