/*
 * Copyright (C) 2016, 2017 Cumulus Networks, Inc. All rights reserved
 */

#ifndef __LINUX_BRIDGE_EBT_SETQOS_H
#define __LINUX_BRIDGE_EBT_SETQOS_H

#define EBT_SETQOS_COS  0x01
#define EBT_SETQOS_DSCP 0x02
#define EBT_SETQOS_MASK (EBT_SETQOS_COS | EBT_SETQOS_DSCP)

#define EBT_SETQOS_MIN_COS 0
#define EBT_SETQOS_MAX_COS 7

#define EBT_SETQOS_DSCP_MASK    0xfc    /* 11111100 */
#define EBT_SETQOS_DSCP_SHIFT   2
#define EBT_SETQOS_DSCP_MAX     0x3f    /* 00111111 */

struct ebt_setqos_info {
	__u8  cos;
	__u8  dscp;
	__u8  bitmask;
	int target;
};
#define EBT_SETQOS_TARGET "setqos"

#endif
