/* Copyright (C) 2013, 2014, 2015, 2017 Cumulus Networks, Inc. All rights reserved
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * https://www.gnu.org/licenses/gpl-2.0-standalone.html
 */

#ifndef __LINUX_BRIDGE_EBT_ERSPAN_H
#define __LINUX_BRIDGE_EBT_ERSPAN_H

#define EBT_ERSPAN_SRC_IP 0x01
#define EBT_ERSPAN_DST_IP 0x02
#define EBT_ERSPAN_TTL    0x04
#define EBT_ERSPAN_PREC   0x08
#define EBT_ERSPAN_MASK (EBT_ERSPAN_SRC_IP | EBT_ERSPAN_DST_IP | EBT_ERSPAN_TTL | EBT_ERSPAN_PREC)

struct ebt_erspan_info {
	__be32 src_ip;
	__be32 dst_ip;
	__u8 ttl;
	__u8 prec;
	__u8  bitmask;
	int target;
};
#define EBT_ERSPAN_TARGET "erspan"

#endif
