/*
 * Copyright (C) 2013, 2014, 2015, 2017 Cumulus Networks, Inc. All rights reserved
 */

/* ebt_span
 *
 * Authors:
 * Bart De Schuymer <bdschuym@pandora.be>
 *
 * April, 2002
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include "../include/ebtables_u.h"
#include <linux/netfilter_bridge/ebt_span.h>

#define _SPAN_DPORT '1'
static struct option opts[] =
{
	{ "dport", required_argument, 0, _SPAN_DPORT },
	{ 0 }
};

static void print_help()
{
	printf(
	"span option:\n"
	" --dport : SPAN output interface\n");
}

static void init(struct ebt_entry_target *target)
{
	struct ebt_span_info *spaninfo =
	   (struct ebt_span_info *)target->data;

	spaninfo->dport[0] = '\0';
	return;
}

#define OPT_SPAN_DPORT  0x01
static int parse(int c, char **argv, int argc,
   const struct ebt_u_entry *entry, unsigned int *flags,
   struct ebt_entry_target **target)
{
	struct ebt_span_info *spaninfo =
	   (struct ebt_span_info *)(*target)->data;
	uint32_t mask;
	char *end;

	switch (c) {
	case _SPAN_DPORT:
		ebt_check_option2(flags, OPT_SPAN_DPORT);
		strncpy(spaninfo->dport, optarg, 16);
		spaninfo->bitmask |= EBT_SPAN_DPORT;
		break;
	default:
		return 0;
	}
	return 1;
}

static void final_check(const struct ebt_u_entry *entry,
   const struct ebt_entry_target *target, const char *name,
   unsigned int hookmask, unsigned int time)
{
	//struct ebt_span_info *spaninfo =
	//   (struct ebt_span_info *)target->data;

	/* TBD */
}

static void print(const struct ebt_u_entry *entry,
   const struct ebt_entry_target *target)
{
	struct ebt_span_info *spaninfo =
	   (struct ebt_span_info *)target->data;

	if (spaninfo->bitmask & EBT_SPAN_DPORT)
		printf("--dport %s ", spaninfo->dport);
}

static int compare(const struct ebt_entry_target *t1,
   const struct ebt_entry_target *t2)
{
	struct ebt_span_info *spaninfo1 =
	   (struct ebt_span_info *)t1->data;
	struct ebt_span_info *spaninfo2 =
	   (struct ebt_span_info *)t2->data;

	return (!memcmp(spaninfo1, spaninfo2, sizeof(*spaninfo1)));
}

static struct ebt_u_target span_target =
{
	.name		= "span",
	.size		= sizeof(struct ebt_span_info),
	.help		= print_help,
	.init		= init,
	.parse		= parse,
	.final_check	= final_check,
	.print		= print,
	.compare	= compare,
	.extra_ops	= opts,
};

void _init(void)
{
	ebt_register_target(&span_target);
}
