/* Copyright 2019-2020 Cumulus Networks, Inc.  All rights reserved */

#ifndef _HASH_TABLE_V2_H_
#define _HASH_TABLE_V2_H_

typedef bool (* hash_table_alloc_callback_t)(hash_table_t *ht, void *cbarg);
typedef void (* hash_table_free_callback_t)(hash_table_t *ht);
typedef void (* hash_node_free_callback_t)(void *data);

/* allocate hash table memory and bound the size */
hash_table_t *
hash_table_alloc_v2(int size,
                    hash_table_alloc_callback_t table_alloc_cb,
                    void *table_alloc_cbarg);

/* takes hash_table out of existence */
void hash_table_free_v2(
        hash_table_t *ht,
        hash_table_free_callback_t table_free_cb,
        hash_node_free_callback_t node_free_cb);

#endif //_HASH_TABLE_V2_H_
