/* Copyright 2019-2020 Cumulus Networks, Inc.  All rights reserved */

#include "cumulus.h"

#include <string.h>
#include <assert.h>

#include "ccan/hash/hash.h"

#include "hashtable.h"

#include "hashtable_v2.h"

hash_table_t *
hash_table_alloc_v2(int size,
                    hash_table_alloc_callback_t table_alloc_cb,
                    void *table_alloc_cbarg)
{
    bool rc = FALSE;
    hash_table_t *ht = NULL;

    ht = hash_table_alloc(size);
    if (ht == NULL) {
        goto error;
    }

    if (table_alloc_cb) {
        rc = table_alloc_cb(ht, table_alloc_cbarg);
        if (rc == FALSE) {
            goto error;
        }
    }

    return ht;

error:
    if (ht != NULL) {
        hash_table_free_v2(ht, NULL, NULL);
        ht = NULL;
    }
    return ht;
}

void
hash_table_free_v2(hash_table_t *ht,
                   hash_table_free_callback_t table_free_cb,
                   hash_node_free_callback_t node_free_cb)
{
    if (table_free_cb) {
        table_free_cb(ht);
    }
    hash_table_free(ht, node_free_cb);
}
