#include "cumulus.h"
#include <stdio.h>
#include "hashtable.h"
#include <unistd.h>
#include <stdlib.h>

struct mydata {
    int value;
    int flag;
};

void test_data_in_array(int NENTRIES)
{
    hash_table_t* myht;
    int i;
    int count;
    struct mydata mydata;
    struct mydata* rvdatap = NULL;

    struct mydata *myarray = calloc(NENTRIES, sizeof(struct mydata));

    int del_cb(void *data, void *cbarg) {
	struct mydata* this = (struct mydata*)data;
	if (this->flag == 0) {
	    return hash_table_foreach_delete;
	} else {
	    printf("keeping %d\n", this->value);
	    return hash_table_foreach_done;
	}
    };

    int read_cb(void *data, void *cbarg) {
	*(int*)cbarg = *(int*)cbarg + 1;
	return hash_table_foreach_done;
    };

    printf("---- test_data_in_array()\n");

    myht = hash_table_alloc(NENTRIES);

    printf("after the alloc\n");

    for (i = 0; i < NENTRIES; i++) {
	myarray[i].value = i;
	myarray[i].flag = 0;
	hash_table_add(myht, &myarray[i].value, sizeof(myarray[i].value),
		       (void*)&myarray[i]);
    }

    count = 0;
    hash_table_foreach(myht, read_cb, &count);
    printf("%d entries in the table\n", count);

    printf("after the add\n");

    for (i = 43; i < 45; i++ ) {
	mydata.value = i;
	if (hash_table_find(myht, &mydata.value, sizeof(mydata.value), (void*)&rvdatap)) {
	    rvdatap->flag = 1;
	}
    }
    hash_table_foreach(myht, del_cb, NULL);

    printf("after the delete\n");

    mydata.value = 44;
    if (hash_table_delete(myht, &mydata.value, sizeof(mydata.value), NULL)) {
	printf("%d has been removed\n", mydata.value);
    } else {
	printf("%d is NOT IN THE TABLE!!!\n", mydata.value);
    }

    mydata.value = 43;
    if (hash_table_find(myht, &mydata.value, sizeof(mydata.value), (void*)&rvdatap)) {
	printf("%d is still there: value = %d : flag = %d\n", mydata.value,
	       rvdatap->value, rvdatap->flag);
    } else {
	printf("%d is NOT IN THE TABLE!!!\n", mydata.value);
    }

    count = 0;
    hash_table_foreach(myht, read_cb, &count);
    printf("%d entries in the table\n", count);

    hash_table_free(myht, NULL);

    printf("after the free\n");
    free(myarray);
}


void test_data_malloc(int NENTRIES)
{
    hash_table_t* myht;
    int i;
    int count;
    struct mydata* mydata;
    struct mydata tmpdata;

    int del_cb(void *data, void *cbarg) {
	struct mydata* this = (struct mydata*)data;
	if (this->flag == 0) {
	    free(data);
	    return hash_table_foreach_delete;
	} else {
	    printf("keeping %d\n", this->value);
	    return hash_table_foreach_done;
	}
    };

    int read_cb(void *data, void *cbarg) {
	struct mydata* tmp = data;
	if (tmp->flag != 0) {
	    printf("non-zero flag at %d\n", tmp->value);
	}
	*(int*)cbarg = *(int*)cbarg + 1;
	return hash_table_foreach_done;
    };

    void free_cb(void *data) {
	free(data);
    };

    printf("---- test_data_malloc()\n");

    /* create collisions!!!! */
    myht = hash_table_alloc(NENTRIES/4);

    printf("after the alloc\n");

    for (i = 0; i < NENTRIES; i++) {
	mydata = malloc(sizeof(*mydata));
	mydata->value = i;
	mydata->flag = 0;
	hash_table_add(myht, &mydata->value, sizeof(mydata->value), mydata);
    }

    count = 0;
    hash_table_foreach(myht, read_cb, &count);
    printf("%d entries in the table\n", count);

    printf("after the add\n");

    for (i = 24; i < 34; i++) {
	tmpdata.value = i;
	if (!hash_table_delete(myht, &tmpdata.value, sizeof(tmpdata.value), (void*)&mydata))
	{
	    printf("COULD NOT FIND entry %d\n", i);
	}
	free(mydata);
    }
    count = 0;
    hash_table_foreach(myht, read_cb, &count);

    printf("after the delete\n");

    tmpdata.value = 27;
    if (hash_table_find(myht, &tmpdata.value, sizeof(tmpdata.value), (void*)&mydata)) {
	printf("%d is still there: value = %d : flag = %d\n", tmpdata.value,
	       mydata->value, mydata->flag);
    } else {
	printf("%d is NOT IN THE TABLE!!!\n", tmpdata.value);
    }

    count = 0;
    hash_table_foreach(myht, read_cb, &count);
    printf("%d entries in the table\n", count);

    hash_table_free(myht, free_cb);

    printf("after the free\n");
}


int main(int argc, char** argv)
{
    test_data_in_array(64);
    test_data_malloc(64);
    return 0;
}
