#!/bin/bash
#Copyright 2012-2020 Cumulus Networks, Inc.  All rights reserved.

CC=${CC:-gcc}

CFILES="hashtable_test.c"
CFILES="$CFILES hashtable.c"
CFILES="$CFILES ../ccan/hash/*.c"
INCS="$INCS ../../include"
INCS="$INCS ../"
INCS="$INCS ../poll"
INCS="$INCS ../log"
INCS="$INCS ../hashtable"
INCS="$INCS ../ccan/"
INCS="$INCS ../ccan/hash/"

LIBS="$LIBS mcheck"
CFLAGS="$CFLAGS -include mcheck.h"

CFLAGS="$CFLAGS -std=gnu99 -Wall -Werror -g -O0"
for INC in $INCS
do
    CFLAGS="$CFLAGS -I$INC"
done

for LIB in $LIBS
do
    LDFLAGS="$LDFLAGS -l$LIB"
done

echo "Building hashtabletest"
echo $CC -o hashtable_test $CFILES $LDFLAGS $CFLAGS
$CC -o hashtable_test $CFILES $LDFLAGS $CFLAGS

echo "Making etags"
etags $CFILES
