/* Copyright 2020 Cumulus Networks, Inc.  All rights reserved. */
#include "dhcpsnoop.h"
#include "dhcpsnoop6.h"
#include "dhcp.h"
#include "dhcp6.h"
#include "cJSON.h"
#include "cJSON_Utils.h"
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/inotify.h>
#include <limits.h>
#include <pthread.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>

#include <netlink/netlink.h>
#include <netlink/route/addr.h>
#include <netlink/route/link.h>
#include <netlink/route/rtnl.h>
#include <netlink/route/route.h>
#include <netlink/route/link/bcm_knet.h>
#include <netlink/route/link/mlx_sx_netdev.h>


int dhcpsnoop6_get_ia_address(struct dhcpv6_packet * dh_pkt, 
	uint16_t addr_type, int udp_pkt_len,
	struct in6_addr *ip6_addr,
	uint32_t *prelife, uint32_t *validlife) {

	int addr_opt_offset;
	int addr_opt;
	int addr_opt_data_len;
	int ip_addr_offset;

	/* Set up address type specifics */
	switch (addr_type) {
		case D6O_IA_NA:
			addr_opt_offset = IA_NA_OFFSET;
			addr_opt = D6O_IAADDR;
			addr_opt_data_len = 24;
			ip_addr_offset = 0;
			break;
		case D6O_IA_TA:
			addr_opt_offset = IA_TA_OFFSET;
			addr_opt = D6O_IAADDR;
			addr_opt_data_len = 24;
			ip_addr_offset = 0;
			break;
		case D6O_IA_PD:
			addr_opt_offset = IA_PD_OFFSET;
			addr_opt = D6O_IAPREFIX;
			addr_opt_data_len = 25;
			ip_addr_offset = 9;
			break;
		default:
			/* shouldn't be here */
			/*syslog(LOG_ERR,"dhcpsnoop6_get_ia_address: "
			  "invalid opt type %d",addr_type);*/
			return -1;
	}
	uint16_t opt_len = 0;
	unsigned char *opt = dh_pkt->options;

	while (opt[1] != addr_type) {
		opt_len = opt_len + opt[3] + 4;
		if (opt_len > (udp_pkt_len - 12)) {
			break;
			return -1;
		}
		opt += opt[3] + 4;
	}

	opt_len = opt_len + opt[3] + 4;
	if (opt_len > (udp_pkt_len - 12)) {
		return -1;
	}

	opt = opt + ((addr_opt_offset) + 4);
	if (opt[1] != addr_opt) {
		return -1;
	}

	opt = opt + 4;	
	memcpy(&ip6_addr->s6_addr,opt,16);

	opt = opt + 16;
	memcpy(prelife,opt,4);

	opt = opt + 4;
	memcpy(validlife,opt,4);
	return 0;
}

int dhcpsnoop6_get_client_identifier(struct dhcpv6_packet * dh_pkt,
		int udp_pkt_len, char *cmac) {

	uint16_t opt_len = 0;
	unsigned char *opt = dh_pkt->options;

	while (opt[1] != D6O_CLIENTID) {
		opt_len = opt_len + opt[3] + 4;
		if (opt_len > (udp_pkt_len - 12)) {
			break;
			return -1;
		}
		opt += opt[3] + 4;
	}


	opt_len = opt_len + opt[3] + 4;
	if (opt_len > (udp_pkt_len - 12)) {
		return -1;
	}

	if (opt[1] != D6O_CLIENTID) {
		return -1;
	}

	if (opt[7] == D6HWT_ETHERNET) {
		memcpy(cmac, opt+12, 6);
		return 0;
	}
	return -1;
}
