#!/bin/bash
#Copyright 2019-2020 Cumulus Networks, Inc.  All rights reserved.

CC=${CC:-gcc}

CFILES="database_test.c"
CFILES="$CFILES database.c"
CFILES="$CFILES ../ccan/hash/*.c"
INCS="$INCS ../../include"
INCS="$INCS ../"
INCS="$INCS ../poll"
INCS="$INCS ../log"
INCS="$INCS ../hashtable"
INCS="$INCS ../database"
INCS="$INCS ../ccan/"
INCS="$INCS ../ccan/hash/"

LIBS="$LIBS mcheck"
CFLAGS="$CFLAGS -include mcheck.h"

CFLAGS="$CFLAGS -std=gnu99 -Wall -Werror -g -O0"
for INC in $INCS
do
    CFLAGS="$CFLAGS -I$INC"
done

for LIB in $LIBS
do
    LDFLAGS="$LDFLAGS -l$LIB"
done

echo "Building databasetest"
echo $CC -o database_test $CFILES $LDFLAGS $CFLAGS
$CC -o database_test $CFILES $LDFLAGS $CFLAGS

echo "Making etags"
etags $CFILES
