/* Copyright 2020 Cumulus Networks, Inc.  All rights reserved. */
#ifndef _DHCPSNOOP_H_
#define _DHCPSNOOP_H_

#include <sys/uio.h>
#include <errno.h>
#include <asm/types.h>
#include <linux/filter.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <netinet/in_systm.h>
#include <linux/ip.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <linux/ip.h>
#include <linux/ipv6.h>
#include <linux/udp.h>
#include <linux/filter.h>
#include <linux/kernel.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <stdbool.h>
#include "hashtable/hashtable.h"
#include <event.h>

#define INET_ADDRSTRLEN 16
#define INET6_ADDRSTRLEN 46
#define DHCP_SNOOP_BINDING_TBL_SIZE 4096
#define DHCP_SNOOP_CONFIG_TBL_SIZE 1024
#define MAX_IFACE 128
#define FILENAME  128
#define MINUTE 60
#define HOUR 60
#define DAY 24
#define TRUE 1
#define FALSE 0
#define DEFAULT_RATE 100
#define ONERECSIZE 500
/*
 * A network interface's MAC address.
 * 20 bytes for the hardware address
 * and 1 byte for the type tag
 */

extern char *aclcommand;
extern char *args[];

#define HARDWARE_ADDR_LEN 20

struct hardware {
	u_int8_t hlen;
	u_int8_t hbuf[HARDWARE_ADDR_LEN + 1];
};


struct interface_info {
	struct interface_info *next;    /* Next interface in list... */
	struct shared_network *shared_network;
	/* Networks connected to this interface. */
	struct hardware hw_address; /* Its physical address. */
	struct in_addr pref_address;/* Preferred Address set by -U option */
	struct in_addr *addresses;  /* Addresses associated with this
								 * interface.
								 */
	int address_count;      /* Number of addresses stored. */
	int address_max;        /* Size of addresses buffer. */
	struct in6_addr *v6addresses;   /* IPv6 addresses associated with
									   this interface. */
	int v6address_count;        /* Number of IPv6 addresses associated
								   with this interface. */
	int v6address_max;      /* Maximum number of IPv6 addresses
							   we can store in current buffer. */

	u_int8_t *circuit_id;       /* Circuit ID associated with this
								   interface. */
	unsigned circuit_id_len;    /* Length of Circuit ID, if there
								   is one. */
	u_int8_t *remote_id;        /* Remote ID associated with this
								   interface (if any). */
	unsigned remote_id_len;     /* Length of Remote ID. */

	char name [IFNAMSIZ];       /* Its name... */
	int index;          /* Its if_nametoindex(). */
	int rfdesc;         /* Its read file descriptor. */
	int rfdesc6;        /* IPv6 read file descriptor */
	int wfdesc;         /* Its write file descriptor, if
						   different. */
	int giaddr_src_desc;        /* write file descriptor, for relay
								   if giaddr_src is enabled */
	unsigned char *rbuf;        /* Read buffer, if required. */
	unsigned int rbuf_max;      /* Size of read buffer. */
	size_t rbuf_offset;     /* Current offset into buffer. */
	size_t rbuf_len;        /* Length of data in buffer. */

	struct ifreq *ifp;      /* Pointer to ifreq struct. */
	int configured;         /* If set to 1, interface has at least
							 * one valid IP address.
							 */
	u_int32_t flags;        /* Control flags... */
#define INTERFACE_REQUESTED 1
#define INTERFACE_AUTOMATIC 2
#define INTERFACE_RUNNING 4
#define INTERFACE_DOWNSTREAM 8
#define INTERFACE_UPSTREAM 16
#define INTERFACE_STREAMS (INTERFACE_DOWNSTREAM | INTERFACE_UPSTREAM)

	/* Only used by DHCP client code. */
	struct client_state *client;
	int dlpi_sap_length;
	struct hardware dlpi_broadcast_addr;
	struct hardware anycast_mac_addr;
	struct event br_event;
	struct event br_event6;
};

typedef uint8_t mac_addr_t[6];

typedef struct inotify_event_bundle_s {
	int inotifyFd;
	int wd;
	struct event notify_ev;
	char br_name[IFNAMSIZ];
}inotify_event_bundle_t;

enum dhcp_type {
	DHCP_SNOOP,
	STATIC
};

typedef struct binding_entry_key_{
	uint32_t ip_add;
	uint32_t vlan;
	mac_addr_t mac_addr;
	char ifName[IFNAMSIZ];
}binding_entry_key_t;

typedef struct dhcp_mac_ip_{
	binding_entry_key_t key;
	int lease;
	unsigned int rx_ifindex;
	uint32_t type;
	uint8_t  state;  
	char rx_ifname[IFNAMSIZ];
} dhcp_mac_ip_t;

typedef struct binding_entry_key_6_{
	struct in6_addr ip_add;
	uint32_t vlan;
	mac_addr_t mac_addr;
	char ifName[IFNAMSIZ];
}binding_entry_key_6_t;

typedef struct dhcp_mac_ip_6_{
	binding_entry_key_6_t key;
	int lease;
	unsigned int rx_ifindex;
	uint32_t type;
	uint8_t  state;
	char rx_ifname[IFNAMSIZ];
} dhcp_mac_ip_6_t;

typedef struct interface_key_s  {
	unsigned long hash;
} interface_key_t;

typedef struct interface_s {
	interface_key_t key;
	char iface[IFNAMSIZ];
	bool	dirty;//
}interface_t;

typedef struct vlan_key_s {
	uint32_t vlan;
	uint32_t ip_version;
} vlan_key_t;

typedef struct vlan_s {
	vlan_key_t key;	
	uint32_t rate_limit;
	bool 	 snooping;
	bool 	 dirty; 
	hash_table_t *trusted_iface;
	hash_table_t *untrusted_iface;    
}vlan_t;

typedef struct bridge_key_s {
	unsigned long hash;
}bridge_key_t;

typedef struct bridge_s {
	bridge_key_t br_key;
	char iface[IFNAMSIZ];
	struct interface_info if_info;
	bool	vlan_aware;
	hash_table_t *vlan_table;
	bool	dirty;
	int		if_count;
	inotify_event_bundle_t br_change;
}bridge_t;

static inline unsigned long  hash_str(unsigned char *str)
{
	unsigned long hash = 5381;
	int c;

	while (c = *str++)
		hash = ((hash << 5) + hash) + c; /* hash * 33 + c */

	return hash;
}
#endif
