/* Copyright 2011-2020 Cumulus Networks, Inc.  All rights reserved. */
#ifndef _BITSET_H_
#define _BITSET_H_

typedef struct {
    int size_bits;
    uint8_t *bits;
} bitset_t;

static inline void bitset_setall(bitset_t bs) {
    uint8_t *bytep;
    size_t bytes;
    bytes = (bs.size_bits + 7) / 8;
    memset(bs.bits, -1, bytes);
    if ((bs.size_bits & 8) != 0) {
        bytep = bs.bits + (bytes - 1);
        *bytep = (((uint8_t)0xff) >> (8 - (bs.size_bits % 8)));
    }
}

static inline bitset_t bitset_alloc(int size_bits) {
    bitset_t ret;

    ret.size_bits = size_bits;
    ret.bits = calloc((size_bits + 7) / 8, 1);
    return ret;
}

static inline void bitset_free(bitset_t bs) {
    free(bs.bits);
}

static inline void bitset_set(bitset_t bs, int offset) {
    bs.bits[offset / 8] |= 1 << (offset % 8);
}

static inline void bitset_unset(bitset_t bs, int offset) {
    bs.bits[offset / 8] &= ~(1 << (offset % 8));
}

static inline bool bitset_get(bitset_t bs, int offset) {
    return !!(bs.bits[offset / 8] & (1 << (offset % 8)));
}

static inline void bitset_clear(bitset_t bs) {
    memset(bs.bits, '\0', (bs.size_bits + 7) / 8);
}

static inline int bitset_get_first(bitset_t bs) {
    uint8_t p[16] = {0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    int i = 0, bn = 0;
    do {
        if (bs.bits[i]) {
            bn = (bs.bits[i] & 0x0f)?p[bs.bits[i] & 0x0f]
                                    :p[bs.bits[i] >> 4] + 4;
            return ((i << 3) + bn);
        }
    } while ((++i << 3) < bs.size_bits);
    return -1;
}

#endif
