# DHCP snooping daemon

This Daemon snoops on DHCP messages on VLAN

## Build process

dpkg-buildpackage -uc -us -b -j32

## Installation

dpkg -i dhcpsnoop_1.0-1_amd64.deb 
dpkg -i dhcpsnoop-dbgsym_1.0-1_amd64.deb 


## Usage

Configuration file

/etc/dhcpsnoop/dhcp_snoop.json

```bash
{
  "bridge": [
    { 
      "bridge_id": "br0",
      "vlan_aware": 1,
      "vlan": [
        { 
          "vlan_id": 1002,
          "snooping": 1,
          "rate_limit": 15,
          "ip_version": 6,
          "trusted_interface": [
            "swp6"
          ],
          "untrusted_interface": [
            "swp5",
            "swp7",
            "swp8",
            "swp9",
            "swp10",
            "swp11"
          ]
        }
	  ]
	}
  ]
}
```
DHCP binding table

/etc/dhcpsnoop/dhcp_table.json

```bash
{
	"dhcp_table":	[{
			"Port":	"swp5",
			"VLAN":	1002,
			"IP":	"20.0.3.70",
			"MAC":	"00:02:00:00:00:04",
			"Type":	0,
			"Lease":	6420,
			"State":	3,
			"Bridge":	"br0"
		}, {
			"Port":	"swp7",
			"VLAN":	1002,
			"IP":	"20.0.3.71",
			"MAC":	"00:02:00:00:00:06",
			"Type":	0,
			"Lease":	6960,
			"State":	5,
			"Bridge":	"br0"
		}]
}
```
## Enable service

```bash
systemctl enable dhcpsnoop
Created symlink /etc/systemd/system/dhcpsnoop.service → /lib/systemd/system/dhcpsnoop.service.
Created symlink /etc/systemd/system/multi-user.target.wants/dhcpsnoop.service → /lib/systemd/system/dhcpsnoop.service.

systemctl status dhcpsnoop
● dhcpsnoop.service - DHCP snooping service
   Loaded: loaded (/lib/systemd/system/dhcpsnoop.service; enabled; vendor preset: enabled)
   Active: active (running) since Wed 2020-04-29 14:04:27 UTC; 3h 55min ago
 Main PID: 31958 (dhcpsnoop)
   Memory: 608.0K
   CGroup: /system.slice/dhcpsnoop.service
           └─31958 /usr/bin/dhcpsnoop
```
## License
