#! /usr/bin/python

# Copyright 2012 Cumulus Networks LLC, all rights reserved
# Copyright 2016,2017 Cumulus Networks, Inc.  All rights reserved

#############################################################################
#
# Cumulus support cleanup script
#
############################################################################


try:
	import sys
	import os
	import time
	import glob
	import datetime
	import shutil
	import ctypes

except ImportError, e:
	raise ImportError(str(e) + "- required module not found")

supportDir = "/var/support/"

# get used space on a filesystem, returned as floating percentage
def getusedspace(path):
    try:
        libc = ctypes.CDLL("libc.so.6")
        # sync so df statvfs gets updated info.
        libc.sync()
    except EnvironmentError, e:
        print 'Error syncing filesystem for ' + path + str(e)

    try:
        stf = os.statvfs(path)
        pct = 100 * (1.0 - (float(stf.f_bfree) / float(stf.f_blocks)))
    except EnvironmentError, e:
        pct = 0.0;
        print 'Error getting free filesystem space for ' + path + str(e)

    return pct

#
# Removes old support files up to limit, and if filesystem is 
# getting full, remove more until enough space is available (or
# only the oldest support file is left)
def cleanupSupportFiles(goodFileCount=14):
    retval = 0
    maxusedpct = 80

    try:
        supportFileList = glob.glob('*_support_*.t*z')
    except EnvironmentError, e:
        print('Error reading dir ' + supportDir + ' for support files : '
            + str(e))
        return 1

    usedpct = getusedspace(supportDir)

    if (len(supportFileList) <= goodFileCount and ( usedpct < maxusedpct
            or len(supportFileList) < 2)):
            return retval

    supportFileList.sort(reverse=True)
    # delete all but 14 files, keeping oldest by glob sort
    if goodFileCount < len(supportFileList):
        for i in range(goodFileCount-1, len(supportFileList) - 1):
            try:
                print 'deleting file: ' + supportFileList[i]
                os.unlink(supportFileList[i])
            except EnvironmentError, e:
                print 'Error unlinking file ' + supportFileList[i] + str(e)
                retval = 1
                continue

    nfiles = min(len(supportFileList), goodFileCount)
    if usedpct < maxusedpct or nfiles < 2:
            return retval

    for i in range(1, nfiles):
        usedpct = getusedspace(supportDir)
        if usedpct <= maxusedpct:
            break;
        try:
            print 'deleting file to free space: ' + supportFileList[i]
            os.unlink(supportFileList[i])
        except EnvironmentError, e:
            print 'Error unlinking file ' + supportFileList[i] + str(e)
            retval = 1
            continue
    return retval

# If we find cl_support directories, and they are more than an hour old, assume
# that a support timed out or the system crashed, and remove the whole
# directory tree.
def cleanupSupportDirs():
	retval = 0
	try:
		supportDirList = glob.glob('*_support_*[0-9]*_[0-9]*[0-9]')
	except EnvironmentError, e:
		print 'Error checking for support partial directories ' + str(e)
		return 1

	if len(supportDirList) < 1:
		return retval

	hour_ago = datetime.datetime.today() - datetime.timedelta(hours=1)
	for adir in supportDirList:
		try:
			dirtime = datetime.datetime.fromtimestamp(os.path.getmtime(adir))
			if os.path.isdir(adir) and dirtime < hour_ago:
				print 'Removing directory tree ' + supportDir +  adir + '.'
				shutil.rmtree(adir, ignore_errors=True)

		except EnvironmentError, e:
			print 'Error checking ' + adir + ' for support partial directories ' + str(e)
			retval = 1

	return retval

try:
	os.chdir(supportDir)
except EnvironmentError, e:
	print 'Unable to chdir to ' + supportDir + ' to cleanup files : ' + str(e)
	sys.exit(1)

errors = cleanupSupportFiles()
errors += cleanupSupportDirs()

# avoid really frequent runs by delaying before terminating.
time.sleep(60)
sys.exit(errors)
