#!/bin/bash
# Copyright 2015, 2016, 2017, Cumulus Networks, Inc.  All rights reserved.

#############################################################
# This script calls cl-support if it finds
# any core files under the path passed as argument
# to the script.
#
# This script is invoked by monit on timestamp changes
# to the /var/support/core dir. This script maybe called
# more than once when the core file is being written to
# under /var/support/core. The script invokes cl-support
# only when there are *.core.xz files available
#
#############################################################

if [ $# -ne 1 ]; then
	echo "usage: $0 <path to coredir>"
	exit 1
fi

coredir_path=$1

# if we can't cd, bail out with an error
cd ${coredir_path} || { logger -p err -t cumulus-core Failed to cd to "$1". ; exit 1; }
cores=$(echo *)
cd /
if [ "${cores}" != '*' ]; then
    logger -p err -t cumulus-core Running cl-support for core files "${cores}"
	/usr/cumulus/bin/cl-support -r "found core file(s): ${cores}"
    # else must have been cleaned up by another cl-support already
fi
sleep 60 # don't run too often
